% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{register_indicator}
\alias{register_indicator}
\title{Register a new indicator to mapme.biodiversity}
\usage{
register_indicator(
  name = NULL,
  resources = NULL,
  fun = NULL,
  arguments = NULL,
  processing_mode = NULL
)
}
\arguments{
\item{name}{A character vector indicating the name of the indicator.}

\item{resources}{A list with named objects indicating the resources
that need to be available to calculate the indicator. The names correspond
to registered resources and a single character value indicates the
type of that resources}

\item{fun}{The function you wish to register.}

\item{arguments}{A list with named entries indicating the default values
for the arguments required by the function}

\item{processing_mode}{A character vector indicating the preferred
processing mode of the indicator. Either 'asset' or 'portfolio'.}
}
\value{
Nothing. Registers the function in the package environment.
}
\description{
Registers a custom indicator function to access indicators not native to
\code{mapme.biodiversity} to be used with \code{calc_indicators()}. Custom
indicators will also be registered in the list generated by
\code{available_indicators()}.
}
\details{
Note that registering your own indicator function will only have effect for
the current R session. If you return to your analysis in a new session, you
will have to re-register your custom indicator.
}
\examples{
\dontrun{
register_indicator(
  name = "treecover_area",
  inputs = list(
    gfw_treecover = "raster",
    gfw_lossyear = "raster"
  ),
  fun = .calc_treecover_area,
  arguments = list(
    min_size = 10,
    min_cover = 30
  ),
  processing_mode = "asset"
)
}
}
