% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_snp_filter.R
\name{rf_snp_filter}
\alias{rf_snp_filter}
\title{Remove markers that do not meet a LOD criteria}
\usage{
rf_snp_filter(
  input.twopt,
  thresh.LOD.ph = 5,
  thresh.LOD.rf = 5,
  thresh.rf = 0.15,
  probs = c(0.05, 1),
  ncpus = 1L,
  diagnostic.plot = TRUE
)
}
\arguments{
\item{input.twopt}{an object of class \code{poly.est.two.pts.pairwise}}

\item{thresh.LOD.ph}{LOD score threshold for linkage phase configuration (default = 5)}

\item{thresh.LOD.rf}{LOD score threshold for recombination fraction (default = 5)}

\item{thresh.rf}{threshold for recombination fractions (default = 0.15)}

\item{probs}{indicates the probability corresponding to the filtering quantiles. (defaul = c(0.05, 1))}

\item{ncpus}{number of parallel processes (i.e. cores) to spawn (default = 1)}

\item{diagnostic.plot}{if \code{TRUE} produces a diagnostic plot}
}
\value{
A filtered object of class \code{mappoly.sequence}. 
See \code{\link[mappoly]{make_seq_mappoly}} for details
}
\description{
Remove markers that do not meet a LOD and recombination fraction
 criteria for at least a percentage of the pairwise marker
 combinations. It also removes markers with strong evidence of
 linkage across the whole linkage group (false positive).
}
\details{
\code{thresh.LOD.ph} should be set in order to only select
    recombination fractions that have LOD scores associated to the
    linkage phase configuration higher than \code{thresh_LOD_ph}
    when compared to the second most likely linkage phase configuration.
    That action usually eliminates markers that are unlinked to the
    set of analyzed markers.
}
\examples{
    all.mrk<-make_seq_mappoly(hexafake, 1:20)
    red.mrk<-elim_redundant(all.mrk)
    unique.mrks<-make_seq_mappoly(red.mrk)
    all.pairs<-est_pairwise_rf(input.seq = unique.mrks,
                               ncpus = 1,
                               verbose=TRUE)

    ## Full recombination fraction matrix
    mat.full<-rf_list_to_matrix(input.twopt=all.pairs)
    plot(mat.full)

    ## Removing disruptive SNPs
    tpt.filt<-rf_snp_filter(all.pairs, 2, 2, 0.07, probs = c(0.15, 1))
    p1.filt<-make_pairs_mappoly(input.seq = tpt.filt, input.twopt = all.pairs)
    m1.filt<-rf_list_to_matrix(input.twopt = p1.filt)
    plot(mat.full, main.text = "LG1")
    plot(m1.filt, main.text = "LG1.filt")
   
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu} with updates by Gabriel Gesteira, \email{gabrielgesteira@usp.br}
}
