% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haplotype_map_utils.R
\name{generate_all_link_phases_elim_equivalent_haplo}
\alias{generate_all_link_phases_elim_equivalent_haplo}
\title{Eliminate equivalent linkage phases}
\usage{
generate_all_link_phases_elim_equivalent_haplo(
  block1,
  block2,
  rf.matrix,
  ploidy,
  max.inc = NULL
)
}
\arguments{
\item{block1}{submap with markers of the first block}

\item{block2}{submap with markers of the second block, 
or just a single marker identified by its position on
 the \code{mappoly.data} object}

\item{rf.matrix}{matrix obtained with the function \code{rf_list_to_matrix}
using the parameter \code{shared.alleles = TRUE}}

\item{ploidy}{ploidy level (i.e. 4, 6 and so on)}

\item{max.inc}{maximum number of allowed inconsistencies (default = NULL: don't check inconsistencies)}
}
\description{
Generates all possible linkage phases between two blocks of markers
(or a block and a marker), eliminating equivalent configurations, 
i.e. configurations with the same likelihood and also considering
the two-point information (shared alleles)
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu} and Gabriel Gesteira, \email{gabrielgesteira@usp.br}
}
\keyword{internal}
