% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_rf.R
\name{est_pairwise_rf2}
\alias{est_pairwise_rf2}
\title{Pairwise two-point analysis - RcppParallel version}
\usage{
est_pairwise_rf2(
  input.seq,
  ncpus = 1L,
  mrk.pairs = NULL,
  verbose = TRUE,
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{input.seq}{an object of class \code{mappoly.sequence}}

\item{ncpus}{Number of parallel processes (cores) to spawn (default = 1)}

\item{mrk.pairs}{a matrix of dimensions 2*N, containing N
pairs of markers to be analyzed. If \code{NULL} (default), all pairs are
considered}

\item{verbose}{If \code{TRUE} (default), current progress is shown; if
\code{FALSE}, no output is produced}

\item{tol}{the desired accuracy. See \code{optimize()} for details}
}
\value{
An object of class \code{mappoly.twopt2}
}
\description{
Performs the two-point pairwise analysis between all markers in a sequence. 
For each pair, the function estimates the recombination fraction for all 
possible linkage phase configurations and associated LOD Scores.
}
\details{
Differently from est_pairwise_rf this function returns only the values associated 
 to the best linkage phase configuration.
}
\examples{
  ## Tetraploid example  
  all.mrk <- make_seq_mappoly(tetra.solcap, 100:200)
  all.pairs <- est_pairwise_rf2(input.seq = all.mrk, ncpus = 2)
  m <- rf_list_to_matrix(all.pairs)
  plot(m, fact = 2)
  
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
