% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e.r
\name{e}
\alias{e}
\title{e}
\usage{
e(observed, predicted)
}
\arguments{
\item{observed}{Numeric vector of observed values}

\item{predicted}{Numeric vector of predicted values. The length shall be
the same as for observed.}
}
\value{
The Nash-Sutcliffe modelling efficiency (E) calculated from observed and
predicted values.
}
\description{
Calculates the Nash-Sutcliffe modelling efficiency (E)
from observed and predicted values.
}
\details{
E = 1 - sum(observed - predicted)/sum(observed - mean (observed))
}
\examples{
o<-1:5
p<-c(2,2,4,3,5)
e(observed=o, predicted=p)

}
\references{
Nash, J. E., & Sutcliffe, J. V. (1970). River flow forecasting
through conceptual models part I—A discussion of principles. Journal of
hydrology, 10(3), 282-290.
}
