% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popupImage.R
\name{popupImage}
\alias{popupImage}
\title{Create HTML strings for popup graphs}
\usage{
popupImage(img, src = c("local", "remote"), ...)
}
\arguments{
\item{img}{A character \code{vector} of file path(s) or
web-URL(s) to any sort of image file(s).}

\item{src}{Whether the source is "local" (i.e. valid file path(s)) or
"remote" (i.e. valid URL(s)).}

\item{...}{width and height (in pixels) can be passed to underlying functions.}
}
\value{
A \code{list} of HTML strings required to create popup graphs.
}
\description{
Create HTML strings for \code{popup} graphs used as input for
\code{\link{mapview}} or \code{\link{leaflet}}.
}
\examples{
\dontrun{
## remote images -----
### one image
pt <- data.frame(x = 174.764474, y = -36.877245)
coordinates(pt) <- ~ x + y
proj4string(pt) <- "+init=epsg:4326"

img <- "http://bit.ly/1TVwRiR"

mapview(pt, popup = popupImage(img, src = "remote"))

### multiple file (types)
images <- c(img,
            "https://upload.wikimedia.org/wikipedia/commons/1/1b/R_logo.svg",
            "https://www.r-project.org/logo/Rlogo.png",
            "https://upload.wikimedia.org/wikipedia/commons/d/d6/MeanMonthlyP.gif")

pt4 <- data.frame(x = jitter(rep(174.764474, 4), factor = 0.01),
                  y = jitter(rep(-36.877245, 4), factor = 0.01))
coordinates(pt4) <- ~ x + y
proj4string(pt4) <- "+init=epsg:4326"

mapview(pt4, popup = popupImage(images, src = "remote")) # NOTE the gif animation

## local images -----
img <- system.file("img","Rlogo.png",package="png")
mapview(pt, popup = popupImage(img))
}

}
\seealso{
\code{\link{popupTable}} and \code{\link{popupGraph}}.
}

