% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.predictions}
\alias{tidy.predictions}
\title{Tidy a \code{predictions} object}
\usage{
\method{tidy}{predictions}(x, conf_level = 0.95, by = NULL, ...)
}
\arguments{
\item{x}{An object produced by the \code{predictions} function.}

\item{conf_level}{numeric value between 0 and 1. Confidence level to use to build a confidence interval.}

\item{by}{Character vector of variable names over which to compute group-averaged contrasts.}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} documentation for a non-exhaustive list of available
arguments.}
}
\value{
A "tidy" \code{data.frame} of summary statistics which conforms to the
\code{broom} package specification.
}
\description{
Calculate average adjusted predictions by taking the mean of all the
unit-level adjusted predictions computed by the \code{predictions} function.
}
\examples{
mod <- lm(mpg ~ hp * wt + factor(gear), data = mtcars)
mfx <- predictions(mod)
tidy(mfx)
}
