% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nps_trend.R
\name{nps_trend}
\alias{nps_trend}
\title{Tidy Calculation of Net Promoter Score trends by group}
\usage{
nps_trend(survey_data, trend_var, ..., min_surveys = 1, avg_surveys = 0)
}
\arguments{
\item{survey_data}{Raw survey data. Needs to be one row per survey with the nps question
in a numeric column called nps_question}

\item{trend_var}{Column that represents an element of time, eg week number, date, month & year}

\item{...}{optional columns by which to group the nps calculation. There is no limit to
the number of grouping variables chosen. Too many will likely result in nps calculations
that are too fragmented / based on very small survey counts.}

\item{min_surveys}{Minimum surveys found in every period for each group to be included}

\item{avg_surveys}{Average surveys found in every period for each group to be included}
}
\value{
Data frame with nps and survey count for each combination of the grouping variables over
the time variable.
}
\description{
Simplifies the calculation of Net Promoter Score (NPS) trends over time from raw survey
data within the tidyverse framework.
}
\details{
Net Promoter Score was originally developed by Fred Reichheld and now is owned by
Bain Company and Satmetrix Systems. According to Wikipedia it "is a management
tool that can be used to gauge the loyalty of a firm's customer relationships."

The trend version of the function allows you to specify one column as a date over which to
trend the data. This allows quick filtering to eliminate groupings that fail to meet
user-specified thresholds for average or minimum survey counts per time period.

The resulting data set is set up for creating faceted line plots using ggplot2.
}
\examples{
nps_question <- sample(10, 100, replace = TRUE)
nps_date <- rep(seq.Date(from = as.Date("2019-01-01"), to = as.Date("2019-01-10"), by = "day"), 10)
nps_group <- rep(c("a", "b", "c", "d"), 25)
df <- data.frame(nps_question, nps_date, nps_group)
nps_trend(df, nps_date, nps_group)
}
