% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_fit.R
\name{logLik.market_fit}
\alias{logLik.market_fit}
\alias{logLik,market_fit-method}
\title{Log likelihood of a fitted market model.}
\usage{
\method{logLik}{market_fit}(object, ...)

\S4method{logLik}{market_fit}(object, ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{...}{Additional arguments. Unused.}
}
\value{
A \code{\link[stats]{logLik}} object.
}
\description{
Specializes the \code{\link[stats]{logLik}} function for the market models
of the package estimated with full information minimum likelihood. It
returns \code{NULL} for the equilibrium model estimated with two stage
least squares (\code{2SLS}).
}
\examples{
\donttest{
# estimate a model using the houses dataset
fit <- diseq_deterministic_adjustment(
  HS | RM | ID | TREND ~
    RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
      RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),
  correlated_shocks = FALSE,
  estimation_options = list(control = list(maxit = 1e+6))
)

# get the log likelihood object
logLik(fit)
}
}
