% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/diseq_basic.R,
%   R/diseq_deterministic_adjustment.R, R/diseq_directional.R,
%   R/diseq_stochastic_adjustment.R, R/equilibrium_model.R, R/hessian_basic.R,
%   R/hessian_directional.R, R/market_fit.R
\name{model_likelihoods}
\alias{model_likelihoods}
\alias{log_likelihood}
\alias{gradient}
\alias{hessian}
\alias{scores}
\alias{log_likelihood,diseq_basic-method}
\alias{gradient,diseq_basic-method}
\alias{scores,diseq_basic,ANY,ANY-method}
\alias{log_likelihood,diseq_deterministic_adjustment-method}
\alias{gradient,diseq_deterministic_adjustment-method}
\alias{scores,diseq_deterministic_adjustment,ANY,ANY-method}
\alias{log_likelihood,diseq_directional-method}
\alias{gradient,diseq_directional-method}
\alias{scores,diseq_directional,ANY,ANY-method}
\alias{log_likelihood,diseq_stochastic_adjustment-method}
\alias{gradient,diseq_stochastic_adjustment-method}
\alias{scores,diseq_stochastic_adjustment,ANY,ANY-method}
\alias{log_likelihood,equilibrium_model-method}
\alias{gradient,equilibrium_model-method}
\alias{scores,equilibrium_model,ANY,ANY-method}
\alias{hessian,diseq_basic-method}
\alias{hessian,diseq_directional-method}
\alias{scores,missing,missing,market_fit-method}
\title{Model likelihoods and derivatives.}
\usage{
log_likelihood(object, parameters)

gradient(object, parameters)

hessian(object, parameters)

scores(object, parameters, fit)

\S4method{log_likelihood}{diseq_basic}(object, parameters)

\S4method{gradient}{diseq_basic}(object, parameters)

\S4method{scores}{diseq_basic,ANY,ANY}(object, parameters)

\S4method{log_likelihood}{diseq_deterministic_adjustment}(object, parameters)

\S4method{gradient}{diseq_deterministic_adjustment}(object, parameters)

\S4method{scores}{diseq_deterministic_adjustment,ANY,ANY}(object, parameters)

\S4method{log_likelihood}{diseq_directional}(object, parameters)

\S4method{gradient}{diseq_directional}(object, parameters)

\S4method{scores}{diseq_directional,ANY,ANY}(object, parameters)

\S4method{log_likelihood}{diseq_stochastic_adjustment}(object, parameters)

\S4method{gradient}{diseq_stochastic_adjustment}(object, parameters)

\S4method{scores}{diseq_stochastic_adjustment,ANY,ANY}(object, parameters)

\S4method{log_likelihood}{equilibrium_model}(object, parameters)

\S4method{gradient}{equilibrium_model}(object, parameters)

\S4method{scores}{equilibrium_model,ANY,ANY}(object, parameters)

\S4method{hessian}{diseq_basic}(object, parameters)

\S4method{hessian}{diseq_directional}(object, parameters)

\S4method{scores}{missing,missing,market_fit}(fit)
}
\arguments{
\item{object}{A model object.}

\item{parameters}{A vector with model parameters.}

\item{fit}{A fitted model object.}
}
\value{
The sum of the likelihoods evaluated for each observation.

The log likelihood's gradient.

The log likelihood's hessian.

The score matrix.
}
\description{
Methods that calculate the likelihoods, scores, gradients, and Hessians
of market models.

Returns the log-likelihood. The likelihood functions are based on
Maddala and Nelson (1974) \doi{10.2307/1914215}. The likelihoods expressions
that the function uses are derived in
Karapanagiotis (2020) \doi{10.2139/ssrn.3525622}. The function calculates
the model's log likelihood by evaluating the log likelihood of each observation in
the sample and summing the evaluation results.

Returns the gradient of the log-likelihood evaluated at the passed parameters.

Returns the hessian of the log-likelihood evaluated at the passed parameters.

It calculates the gradient of the likelihood at the given parameter point
for each observation in the sample. It, therefore, returns an n x k matrix,
where n denotes the number of observations in the sample and k the number
of estimated parameters. The ordering of the parameters is the same as
the one that is used in the summary of the results. The method can be
called either using directly a fitted model object, or by separately
providing a model object and a parameter vector.
}
\examples{
\donttest{
model <- simulate_model(
  "diseq_basic", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.9, beta_d0 = 8.9, beta_d = c(0.6), eta_d = c(-0.2),
    # supply coefficients
    alpha_s = 0.9, beta_s0 = 7.9, beta_s = c(0.03, 1.2), eta_s = c(0.1)
  ),
  seed = 7523
)

# estimate the model object (BFGS is used by default)
fit <- estimate(model)

# Calculate the score matrix
head(scores(model, coef(fit)))
}
}
