% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_mix_utils.R
\name{get_prior}
\alias{get_prior}
\title{Get component priors from MarkovFit object}
\usage{
get_prior(object, check = TRUE)
}
\arguments{
\item{object}{\code{\link{MarkovMix}} object.}

\item{check}{Logical (1L) indicating whether to check \code{object}
at the beginning.}
}
\value{
A numeric vector indicates component priors.
}
\description{
\code{get_prior} gets component priors from \code{\link{MarkovMix}} object,
normalized to sum up to 1.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the class.}
}
}
\examples{
# Load example MarkovMix object
data("markov_mix_ex")

# Derive state transition patterns
get_states_mat(markov_mix_ex)

# Derive probability matrices
get_prob(markov_mix_ex)

# Derive component priors
get_prior(markov_mix_ex)

# Combine state transition patterns and their probabilities
cbind(
  as.data.frame(get_states_mat(markov_mix_ex)),
  as.data.frame(get_prob(markov_mix_ex))
)
}
\seealso{
Other MarkovMix utilities: 
\code{\link{get_prob}()},
\code{\link{get_states_mat}()},
\code{\link{restate}()}
}
\author{
Xiurui Zhu
}
\concept{MarkovMix utilities}
