/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class DistanceXYC
extends AbstractBinIntSConstraint {
    protected int operator;
    protected final int cste;
    public static final int EQ = 0;
    public static final int LT = 1;
    public static final int GT = 2;
    public static final int NEQ = 3;

    public DistanceXYC(IntDomainVar v1, IntDomainVar v2, int c, int oper) {
        super(v1, v2);
        this.cste = c;
        this.operator = oper;
        if (oper != 0 && oper != 1 && oper != 2 && oper != 3) {
            throw new SolverException("operateur inconnu " + oper);
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v1.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterFromVarToVar(IntDomainVar var1, IntDomainVar var2) throws ContradictionException {
        DisposableIntIterator it = var1.getDomain().getIterator();
        try {
            while (it.hasNext()) {
                int value = it.next();
                if (var2.canBeInstantiatedTo(value - this.cste) || var2.canBeInstantiatedTo(value + this.cste)) continue;
                var1.removeVal(value, this, false);
            }
        }
        finally {
            it.dispose();
        }
    }

    public void filterGT() throws ContradictionException {
        if (this.cste >= 0) {
            int lbv0 = this.v1.getSup() - this.cste;
            int ubv0 = this.v1.getInf() + this.cste;
            this.v0.removeInterval(lbv0, ubv0, this, false);
            int lbv1 = this.v0.getSup() - this.cste;
            int ubv1 = this.v0.getInf() + this.cste;
            this.v1.removeInterval(lbv1, ubv1, this, false);
        } else {
            this.setEntailed();
        }
    }

    public void filterGTonVar(IntDomainVar vv0, IntDomainVar vv1) throws ContradictionException {
        if (this.cste >= 0) {
            int lbv0 = vv0.getSup() - this.cste;
            int ubv0 = vv0.getInf() + this.cste;
            vv1.removeInterval(lbv0, ubv0, this, false);
        } else {
            this.setEntailed();
        }
    }

    public void filterLT() throws ContradictionException {
        this.v0.updateInf(this.v1.getInf() - this.cste + 1, this, false);
        this.v0.updateSup(this.v1.getSup() + this.cste - 1, this, false);
        this.v1.updateInf(this.v0.getInf() - this.cste + 1, this, false);
        this.v1.updateSup(this.v0.getSup() + this.cste - 1, this, false);
    }

    public void filterLTonVar(IntDomainVar vv0, IntDomainVar vv1) throws ContradictionException {
        vv1.updateInf(vv0.getInf() - this.cste + 1, this, false);
        vv1.updateSup(vv0.getSup() + this.cste - 1, this, false);
    }

    public void filterOnInf(IntDomainVar vv0, IntDomainVar vv1) throws ContradictionException {
        if (vv1.hasEnumeratedDomain()) {
            IntDomain dom = vv1.getDomain();
            int end = vv0.getInf() + this.cste;
            int val = vv0.getInf();
            while (val <= end) {
                if (!vv0.canBeInstantiatedTo(val - this.cste) && !vv0.canBeInstantiatedTo(val + this.cste)) {
                    vv1.removeVal(val, this, false);
                }
                val = dom.getNextValue(val);
            }
        } else {
            vv1.updateInf(vv0.getInf() - this.cste, this, false);
        }
    }

    public void filterOnSup(IntDomainVar vv0, IntDomainVar vv1) throws ContradictionException {
        if (vv1.hasEnumeratedDomain()) {
            IntDomain dom = vv1.getDomain();
            int initval = vv0.getSup() - this.cste > vv1.getInf() ? dom.getNextValue(vv0.getSup() - this.cste - 1) : vv1.getInf();
            int val = initval;
            do {
                if (vv0.canBeInstantiatedTo(val - this.cste) || vv0.canBeInstantiatedTo(val + this.cste)) continue;
                vv1.removeVal(val, this, false);
            } while ((val = dom.getNextValue(val)) <= vv1.getSup() && val > initval);
        } else {
            vv1.updateSup(vv0.getSup() + this.cste, this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterOnInst(IntDomainVar v, int val) throws ContradictionException {
        if (!v.canBeInstantiatedTo(val + this.cste)) {
            v.instantiate(val - this.cste, this, false);
        } else if (!v.canBeInstantiatedTo(val - this.cste)) {
            v.instantiate(val + this.cste, this, false);
        } else if (v.hasEnumeratedDomain()) {
            DisposableIntIterator it = v.getDomain().getIterator();
            try {
                while (it.hasNext()) {
                    int value = it.next();
                    if (value == val - this.cste || value == val + this.cste) continue;
                    v.removeVal(value, this, false);
                }
            }
            finally {
                it.dispose();
            }
        } else {
            v.updateInf(val - this.cste, this, false);
            v.updateSup(val + this.cste, this, false);
        }
    }

    public void filterNeq() throws ContradictionException {
        if (this.cste >= 0) {
            if (this.v0.isInstantiated()) {
                this.v1.removeVal(this.v0.getVal() + this.cste, this, false);
                this.v1.removeVal(this.v0.getVal() - this.cste, this, false);
            }
            if (this.v1.isInstantiated()) {
                this.v0.removeVal(this.v1.getVal() + this.cste, this, false);
                this.v0.removeVal(this.v1.getVal() - this.cste, this, false);
            }
        } else {
            this.setEntailed();
        }
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.cste < 0) {
            switch (this.operator) {
                case 0: 
                case 1: {
                    this.fail();
                    break;
                }
                case 2: 
                case 3: {
                    this.setEntailed();
                }
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.operator == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                this.filterFromVarToVar(this.v0, this.v1);
            } else {
                this.v0.updateInf(this.v1.getInf() - this.cste, this, false);
                this.v0.updateSup(this.v1.getSup() + this.cste, this, false);
            }
            if (this.v1.hasEnumeratedDomain()) {
                this.filterFromVarToVar(this.v1, this.v0);
            } else {
                this.v1.updateInf(this.v0.getInf() - this.cste, this, false);
                this.v1.updateSup(this.v0.getSup() + this.cste, this, false);
            }
        } else if (this.operator == 2) {
            this.filterGT();
        } else if (this.operator == 1) {
            this.filterLT();
        } else {
            this.filterNeq();
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (this.operator == 0) {
            if (idx == 0) {
                if (!this.v0.canBeInstantiatedTo(x + 2 * this.cste)) {
                    this.v1.removeVal(x + this.cste, this, false);
                }
                if (!this.v0.canBeInstantiatedTo(x - 2 * this.cste)) {
                    this.v1.removeVal(x - this.cste, this, false);
                }
            } else {
                if (!this.v1.canBeInstantiatedTo(x + 2 * this.cste)) {
                    this.v0.removeVal(x + this.cste, this, false);
                }
                if (!this.v1.canBeInstantiatedTo(x - 2 * this.cste)) {
                    this.v0.removeVal(x - this.cste, this, false);
                }
            }
        } else if (this.operator == 3) {
            this.filterNeq();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.operator == 0) {
            if (idx == 0) {
                this.filterOnSup(this.v0, this.v1);
            } else {
                this.filterOnSup(this.v1, this.v0);
            }
        } else if (this.operator == 2) {
            if (idx == 0) {
                this.filterGTonVar(this.v0, this.v1);
            } else {
                this.filterGTonVar(this.v1, this.v0);
            }
        } else if (this.operator == 1) {
            if (idx == 0) {
                this.filterLTonVar(this.v0, this.v1);
            } else {
                this.filterLTonVar(this.v1, this.v0);
            }
        } else {
            this.filterNeq();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.operator == 0) {
            if (idx == 0) {
                this.filterOnInf(this.v0, this.v1);
            } else {
                this.filterOnInf(this.v1, this.v0);
            }
        } else if (this.operator == 2) {
            if (idx == 0) {
                this.filterGTonVar(this.v0, this.v1);
            } else {
                this.filterGTonVar(this.v1, this.v0);
            }
        } else if (this.operator == 1) {
            if (idx == 0) {
                this.filterLTonVar(this.v0, this.v1);
            } else {
                this.filterLTonVar(this.v1, this.v0);
            }
        } else {
            this.filterNeq();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (this.operator == 0) {
            if (idx == 0) {
                this.filterOnInst(this.v1, this.v0.getVal());
            } else {
                this.filterOnInst(this.v0, this.v1.getVal());
            }
        } else if (this.operator == 2) {
            if (idx == 0) {
                this.filterGTonVar(this.v0, this.v1);
            } else {
                this.filterGTonVar(this.v1, this.v0);
            }
        } else if (this.operator == 1) {
            if (idx == 0) {
                this.filterLTonVar(this.v0, this.v1);
            } else {
                this.filterLTonVar(this.v1, this.v0);
            }
        } else {
            this.filterNeq();
        }
    }

    @Override
    public String toString() {
        String op;
        if (this.operator == 0) {
            op = "=";
        } else if (this.operator == 2) {
            op = ">";
        } else if (this.operator == 1) {
            op = "<";
        } else if (this.operator == 3) {
            op = "!=";
        } else {
            throw new SolverException("unknown operator");
        }
        return "|" + this.v0 + " - " + this.v1 + "| " + op + " " + this.cste;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("| ").append(this.v0.pretty()).append(" - ").append(this.v1.pretty()).append(" | ");
        switch (this.operator) {
            case 0: {
                sb.append("=");
                break;
            }
            case 3: {
                sb.append("!=");
                break;
            }
            case 2: {
                sb.append(">");
                break;
            }
            case 1: {
                sb.append("<");
                break;
            }
            default: {
                sb.append("???");
            }
        }
        sb.append(this.cste);
        return sb.toString();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on DistanceXYC constraint");
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        if (this.operator == 0) {
            return Math.abs(tuple[0] - tuple[1]) == this.cste;
        }
        if (this.operator == 1) {
            return Math.abs(tuple[0] - tuple[1]) < this.cste;
        }
        if (this.operator == 2) {
            return Math.abs(tuple[0] - tuple[1]) > this.cste;
        }
        if (this.operator == 3) {
            return Math.abs(tuple[0] - tuple[1]) != this.cste;
        }
        throw new SolverException("operator not known");
    }
}

