% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sri.R
\name{sri}
\alias{sri}
\title{Constraint model to produce all stable matchings in the stable roommates problem with 
incomplete lists}
\usage{
sri(prefs = NULL, nAgents = NULL, seed = NULL, p.min = NULL)
}
\arguments{
\item{prefs}{valuation matrix of dimension \code{nAgents x nAgents} that gives column-players' 
valuation over row players.}

\item{nAgents}{integer that gives the number of players in the market.}

\item{seed}{integer setting the state for random number generation.}

\item{p.min}{integer, when specified produces incomplete preference lists with the length of each 
player's list randomly sampled from the range [p.min, nrow(prefs)].}
}
\value{
\code{sri} returns a list with the following items.
\item{prefs}{agents' preference list.}
\item{matching}{edgelist of matched pairs, inculding the number of the match (\code{matching}).}
}
\description{
Finds all stable matchings (if one exists) in the 
\href{http://en.wikipedia.org/wiki/Stable_roommates_problem}{stable roommates problem} with incomplete lists
using the Prosser (2014) constraint encoding based on either given or randomly generated preferences.
}
\examples{
## Roommate problem with 10 players, given preferences:
prefs <- matrix(rep(1:10, 10), 10, 10)
sri(prefs=prefs)

## Roommate problem with 10 players, random preferences:
sri(nAgents=10, seed=1)

## Roommate problem with no equilibrium matching:
sri(nAgents=10, seed=2)

## Roommate problem with 3 equilibria:
sri(nAgents=10, seed=3)

}
\author{
Thilo Klein
}
\references{
Gusfield, D.M. and R.W. Irving (1989). The Stable Marriage Problem: 
Structure and Algorithms, MIT Press.

Prosser, P. (2014). Stable Roommates and Constraint Programming. \emph{Lecture Notes in Computer Science, CPAIOR 2014 Edition}. 
Springer International Publishing, 8451: 15--28.
}
\keyword{algorithms}

