/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.configure;

import choco.cp.solver.search.AbstractSearchLoopWithRestart;
import choco.cp.solver.search.BranchAndBound;
import choco.cp.solver.search.SearchLoop;
import choco.cp.solver.search.SearchLoopWithRecomputation;
import choco.cp.solver.search.real.RealBranchAndBound;
import choco.cp.solver.search.restart.BasicKickRestart;
import choco.cp.solver.search.restart.IKickRestart;
import choco.cp.solver.search.restart.NogoodKickRestart;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.solver.Configuration;
import choco.kernel.solver.ResolutionPolicy;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.propagation.ShavingTools;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.AbstractOptimize;
import choco.kernel.solver.search.AbstractSearchLoop;
import choco.kernel.solver.search.ISolutionPool;
import choco.kernel.solver.search.SolutionPoolFactory;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;

public final class StrategyFactory {
    private StrategyFactory() {
    }

    public static void setNoStopAtFirstSolution(Solver solver) {
        solver.getConfiguration().putFalse("cp.resolution.stop_at_first_solution");
    }

    public static void setStopAtFirstSolution(Solver solver) {
        solver.getConfiguration().putTrue("cp.resolution.stop_at_first_solution");
    }

    public static boolean isOptimize(Configuration conf) {
        ResolutionPolicy policy = (ResolutionPolicy)((Object)conf.readEnum("cp.resolution.policy", ResolutionPolicy.class));
        return !ResolutionPolicy.SATISFACTION.equals((Object)policy);
    }

    public static void setDoOptimize(Solver solver, boolean maximize) {
        if (maximize) {
            solver.getConfiguration().putEnum("cp.resolution.policy", ResolutionPolicy.MAXIMIZE);
        } else {
            solver.getConfiguration().putEnum("cp.resolution.policy", ResolutionPolicy.MINIMIZE);
        }
    }

    public static boolean doMaximize(Solver solver) {
        Configuration conf = solver.getConfiguration();
        ResolutionPolicy policy = (ResolutionPolicy)((Object)conf.readEnum("cp.resolution.policy", ResolutionPolicy.class));
        return !ResolutionPolicy.SATISFACTION.equals((Object)policy) && ResolutionPolicy.MAXIMIZE.equals((Object)policy);
    }

    public static Boolean doMaximize(Configuration conf) {
        ResolutionPolicy policy = (ResolutionPolicy)((Object)conf.readEnum("cp.resolution.policy", ResolutionPolicy.class));
        switch (policy) {
            case MAXIMIZE: {
                return Boolean.TRUE;
            }
            case MINIMIZE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static int getRecomputationGap(Solver solver) {
        return solver.getConfiguration().readInt("cp.recomputation.gap");
    }

    public static void validateCSP(Solver solver) {
        Configuration conf = solver.getConfiguration();
        if (StrategyFactory.isOptimize(conf) || conf.readBoolean("cp.search.bottom_up")) {
            throw new SolverException("no_objective/optimize conflict");
        }
    }

    public static AbstractOptimize createBranchAndBound(Solver solver) {
        Var var = solver.getObjective();
        if (var instanceof IntDomainVar) {
            return new BranchAndBound(solver, (IntDomainVar)var, StrategyFactory.doMaximize(solver));
        }
        if (var instanceof RealVar) {
            return new RealBranchAndBound(solver, (RealVar)var, StrategyFactory.doMaximize(solver));
        }
        throw new SolverException("invalid objective: " + var.pretty());
    }

    public static IKickRestart createKickRestart(AbstractGlobalSearchStrategy strategy) {
        return strategy.solver.getConfiguration().readBoolean("cp.restart.nogood_recording") ? new NogoodKickRestart(strategy) : new BasicKickRestart(strategy);
    }

    private static AbstractSearchLoop createSearchLoop(AbstractGlobalSearchStrategy strategy, IKickRestart kickRestart, int recomputationGap) {
        return recomputationGap > 1 ? new SearchLoopWithRecomputation(strategy, kickRestart, recomputationGap) : new SearchLoop(strategy, kickRestart);
    }

    public static AbstractSearchLoop createSearchLoop(AbstractGlobalSearchStrategy strategy) {
        AbstractSearchLoop searchLoop = StrategyFactory.createSearchLoop(strategy, StrategyFactory.createKickRestart(strategy), StrategyFactory.getRecomputationGap(strategy.solver));
        if (searchLoop instanceof AbstractSearchLoopWithRestart) {
            ((AbstractSearchLoopWithRestart)searchLoop).setRestartAfterEachSolution(strategy.solver.getConfiguration().readBoolean("cp.restart.after_solution"));
        }
        return searchLoop;
    }

    public static ISolutionPool createSolutionPool(AbstractGlobalSearchStrategy strategy) {
        return SolutionPoolFactory.makeDefaultSolutionPool(strategy, strategy.solver.getConfiguration().readInt("cp.solution.pool_capacity"));
    }

    public static boolean isUsingShavingTools(Solver solver) {
        Configuration conf = solver.getConfiguration();
        return conf.readBoolean("cp.init.propagation.shaving") || conf.readBoolean("cp.init.propagation.dLB") || conf.readBoolean("cp.search.bottom_up");
    }

    public static ShavingTools createShavingTools(Solver solver) {
        if (StrategyFactory.isUsingShavingTools(solver)) {
            Configuration conf = solver.getConfiguration();
            ShavingTools shavingTools = new ShavingTools(solver, conf.readBoolean("cp.init.propagation.shaving.only_decision_vars") ? solver.getIntDecisionVars() : VariableUtils.getIntVars(solver));
            shavingTools.setShavingLowerBound(conf.readBoolean("cp.init.propagation.shaving.dLB"));
            shavingTools.setDetectLuckySolution(conf.readBoolean("cp.search.bottom_up"));
            return shavingTools;
        }
        return null;
    }
}

