/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.variables.delta.IDeltaDomain;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractIntDomain
implements IntDomain {
    final PropagationEngine propagationEngine;
    final IntDomainVar variable;
    protected int currentInfPropagated;
    protected int currentSupPropagated;
    IDeltaDomain deltaDom;

    protected AbstractIntDomain(IntDomainVar aVariable, PropagationEngine propagationEngine) {
        this.propagationEngine = propagationEngine;
        this.variable = aVariable;
    }

    @Override
    public int fastNextValue(int x) {
        return this.getNextValue(x);
    }

    @Override
    public int fastPrevValue(int x) {
        return this.getPrevValue(x);
    }

    public boolean updateSup(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._updateSup(x, cause)) {
            boolean awake = true;
            int val = this.getInf();
            if (this.getSup() == x) {
                awake = forceAwake;
            }
            if (val == this.getSup()) {
                this.restrict(val);
                this.propagationEngine.postInstInt(this.variable, cause, awake);
            } else {
                this.propagationEngine.postUpdateSup(this.variable, cause, awake);
            }
            return true;
        }
        return false;
    }

    public boolean updateInf(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._updateInf(x, cause)) {
            boolean awake = true;
            int val = this.getSup();
            if (this.getInf() == x) {
                awake = forceAwake;
            }
            if (val == this.getInf()) {
                this.restrict(val);
                this.propagationEngine.postInstInt(this.variable, cause, awake);
            } else {
                this.propagationEngine.postUpdateInf(this.variable, cause, awake);
            }
            return true;
        }
        return false;
    }

    public boolean removeVal(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._removeVal(x, cause)) {
            if (this.getInf() == this.getSup()) {
                this.propagationEngine.postInstInt(this.variable, cause, true);
            } else if (x < this.getInf()) {
                this.propagationEngine.postUpdateInf(this.variable, cause, true);
            } else if (x > this.getSup()) {
                this.propagationEngine.postUpdateSup(this.variable, cause, true);
            } else {
                this.propagationEngine.postRemoveVal(this.variable, x, cause, forceAwake);
            }
            return true;
        }
        return false;
    }

    public boolean removeInterval(int a, int b, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (a <= this.getInf()) {
            return this.updateInf(b + 1, cause, forceAwake);
        }
        if (this.getSup() <= b) {
            return this.updateSup(a - 1, cause, forceAwake);
        }
        if (this.variable.hasEnumeratedDomain()) {
            boolean anyChange = false;
            int v = this.getNextValue(a - 1);
            while (v <= b) {
                anyChange |= this.removeVal(v, cause, forceAwake);
                v = this.getNextValue(v);
            }
            return anyChange;
        }
        return false;
    }

    public boolean instantiate(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._instantiate(x, cause)) {
            this.propagationEngine.postInstInt(this.variable, cause, forceAwake);
            return true;
        }
        return false;
    }

    boolean _instantiate(int x, SConstraint cause) throws ContradictionException {
        if (this.variable.isInstantiated()) {
            if (this.variable.getVal() != x) {
                this.propagationEngine.raiseContradiction(cause);
                return true;
            }
            return false;
        }
        if (x < this.getInf() || x > this.getSup() || !this.contains(x)) {
            this.propagationEngine.raiseContradiction(cause);
            return true;
        }
        this.restrict(x);
        return true;
    }

    boolean _updateInf(int x, SConstraint cause) throws ContradictionException {
        if (x > this.getInf()) {
            if (x > this.getSup()) {
                this.propagationEngine.raiseContradiction(cause);
                return true;
            }
            this.updateInf(x);
            return true;
        }
        return false;
    }

    boolean _updateSup(int x, SConstraint cause) throws ContradictionException {
        if (x < this.getSup()) {
            if (x < this.getInf()) {
                this.propagationEngine.raiseContradiction(cause);
            } else {
                this.updateSup(x);
            }
            return true;
        }
        return false;
    }

    boolean _removeVal(int x, SConstraint cause) throws ContradictionException {
        int infv = this.getInf();
        int supv = this.getSup();
        if (infv <= x && x <= supv) {
            if (x == infv) {
                this._updateInf(x + 1, cause);
                if (this.getInf() == supv) {
                    this.restrict(supv);
                }
                return true;
            }
            if (x == supv) {
                this._updateSup(x - 1, cause);
                if (this.getSup() == infv) {
                    this.restrict(infv);
                }
                return true;
            }
            return this.remove(x);
        }
        return false;
    }

    public String toString() {
        return this.pretty();
    }

    @Override
    public final DisposableIntIterator getDeltaIterator() {
        return this.deltaDom.iterator();
    }

    @Override
    public void freezeDeltaDomain() {
        this.deltaDom.freeze();
    }

    @Override
    public boolean releaseDeltaDomain() {
        return this.deltaDom.release();
    }

    @Override
    public final void clearDeltaDomain() {
        this.deltaDom.clear();
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return this.deltaDom.isReleased();
    }

    @Override
    public final IDeltaDomain copyDelta() {
        return this.deltaDom.copy();
    }
}

