/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.propagation;

import choco.cp.solver.propagation.AbstractPropagationEngine;
import choco.cp.solver.propagation.ConstraintEventQueue;
import choco.cp.solver.propagation.VariableEventQueue;
import choco.cp.solver.variables.integer.IntVarEvent;
import choco.cp.solver.variables.set.SetVarEvent;
import choco.kernel.solver.Configuration;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.propagation.event.PropagationEvent;
import choco.kernel.solver.propagation.event.VarEvent;
import choco.kernel.solver.variables.Var;
import java.util.ArrayList;
import java.util.logging.Level;

public class ChocoEngine
extends AbstractPropagationEngine {
    private static int[] indice = new int[1 << ConstraintEvent.NB_PRIORITY];
    private static final char CHAR_NB_P;
    protected ConstraintEventQueue[] constEventQueues;
    private int c_active;
    protected int nbPendingInitConstAwakeEvent;
    protected VariableEventQueue[] varEventQueue;
    private int v_active;
    private ArrayList<PropagationEvent> freeze;
    private int nbFrozenVE;
    private int[] v_order;
    private int[] c_order;

    public ChocoEngine(Solver solver) {
        super(solver);
        int i;
        this.loadSettings(solver.getConfiguration());
        this.constEventQueues = new ConstraintEventQueue[ConstraintEvent.NB_PRIORITY];
        for (i = 1; i < ConstraintEvent.NB_PRIORITY; ++i) {
            this.constEventQueues[i] = new ConstraintEventQueue(this);
        }
        this.varEventQueue = new VariableEventQueue[ConstraintEvent.NB_PRIORITY];
        for (i = 1; i < ConstraintEvent.NB_PRIORITY; ++i) {
            this.varEventQueue[i] = new VariableEventQueue();
        }
        this.nbPendingInitConstAwakeEvent = 0;
    }

    private static int[] toInt(String value) {
        int[] values = new int[value.length() + 1];
        char[] value_c = value.toCharArray();
        for (int i = 0; i < value.length(); ++i) {
            values[i + 1] = CHAR_NB_P - value_c[i];
        }
        return values;
    }

    @Override
    public void loadSettings(Configuration configuration) {
        this.v_order = ChocoEngine.toInt(configuration.readString("cp.propagation.variables.order"));
        this.c_order = ChocoEngine.toInt(configuration.readString("cp.propagation.constraints.order"));
    }

    @Override
    public void clear() {
        int i;
        super.clear();
        for (i = 1; i < this.varEventQueue.length; ++i) {
            this.varEventQueue[i].clear();
        }
        this.v_active = 0;
        for (i = 1; i < this.constEventQueues.length; ++i) {
            this.constEventQueues[i].clear();
        }
        this.c_active = 0;
        this.nbPendingInitConstAwakeEvent = 0;
        if (this.freeze != null) {
            this.freeze.clear();
        }
        this.nbFrozenVE = 0;
    }

    @Override
    public void postEvent(Var v, int basicEvt, SConstraint constraint, boolean forceAwake) {
        VarEvent<? extends Var> event = v.getEvent();
        boolean alreadyEnqueued = event.isEnqueued();
        event.recordEventTypeAndCause(basicEvt, constraint, forceAwake);
        if (!alreadyEnqueued) {
            int p = this.v_order[event.getPriority()];
            this.varEventQueue[p].pushEvent(event);
            this.v_active |= 1 << p;
        }
    }

    @Override
    public boolean postConstAwake(Propagator constraint, boolean init) {
        ConstraintEvent event = (ConstraintEvent)constraint.getEvent();
        if (this.constEventQueues[this.c_order[event.getPriority()]].pushEvent(event)) {
            int p = this.c_order[event.getPriority()];
            this.c_active |= 1 << p;
            event.setInitialized(!init);
            if (init) {
                this.incPendingInitConstAwakeEvent();
            }
            return true;
        }
        return false;
    }

    @Override
    public void registerPropagator(Propagator c) {
        PropagationEvent event = c.getEvent();
        this.constEventQueues[this.c_order[event.getPriority()]].add(event);
    }

    @Override
    public void propagateEvents() throws ContradictionException {
        while (true) {
            int idx;
            if (this.v_active > 0) {
                idx = indice[this.v_active];
                this.varEventQueue[idx].propagateAllEvents();
                if (!this.varEventQueue[idx].isEmpty()) continue;
                this.v_active -= 1 << idx;
                continue;
            }
            if (this.c_active > 0) {
                idx = indice[this.c_active];
                if (this.constEventQueues[idx].size() == 1) {
                    this.c_active -= 1 << idx;
                }
                this.constEventQueues[idx].propagateOneEvent();
            }
            if (this.v_active <= 0 && this.c_active <= 0) break;
        }
        assert (this.checkCleanState());
    }

    @Override
    public void desactivatePropagator(Propagator propagator) {
        PropagationEvent event = propagator.getEvent();
        int idx = this.c_order[propagator.getPriority()];
        if (this.constEventQueues[idx].remove(event) && this.constEventQueues[idx].isEmpty()) {
            this.c_active -= 1 << idx;
        }
    }

    @Override
    public void decPendingInitConstAwakeEvent() {
        --this.nbPendingInitConstAwakeEvent;
    }

    @Override
    public void incPendingInitConstAwakeEvent() {
        ++this.nbPendingInitConstAwakeEvent;
    }

    public int getNbPendingEvents() {
        int i;
        int nbEvts = 0;
        for (i = 1; i < ConstraintEvent.NB_PRIORITY; ++i) {
            nbEvts += this.varEventQueue[i].size();
        }
        for (i = 1; i < ConstraintEvent.NB_PRIORITY; ++i) {
            nbEvts += this.constEventQueues[i].size();
        }
        return nbEvts;
    }

    public PropagationEvent getPendingEvent(int idx) {
        ConstraintEventQueue q;
        int varsSize = 0;
        for (int i = 1; i < this.varEventQueue.length; ++i) {
            if (this.nbPendingInitConstAwakeEvent > 0) {
                idx += this.varEventQueue[i].size();
            }
            if (idx >= (varsSize += this.varEventQueue[i].size())) continue;
            return this.varEventQueue[i].get(idx);
        }
        int size = varsSize;
        int qidx = 1;
        while ((idx -= size) >= (size = (q = this.constEventQueues[qidx++]).size()) && qidx < this.constEventQueues.length) {
        }
        if (idx <= size) {
            return q.get(idx);
        }
        if (this.nbPendingInitConstAwakeEvent > 0) {
            for (int i = 1; i < this.varEventQueue.length; ++i) {
                if (idx >= (varsSize += this.varEventQueue[i].size())) continue;
                return this.varEventQueue[i].get(idx);
            }
        }
        return null;
    }

    @Override
    public void flushEvents() {
        int i;
        for (i = 1; i < this.varEventQueue.length; ++i) {
            this.varEventQueue[i].flushEventQueue();
        }
        this.v_active = 0;
        for (i = 1; i < this.constEventQueues.length; ++i) {
            this.constEventQueues[i].flushEventQueue();
        }
        this.c_active = 0;
        this.nbPendingInitConstAwakeEvent = 0;
    }

    @Override
    public boolean checkCleanState() {
        boolean ok = true;
        int nbiv = this.solver.getNbIntVars();
        for (int i = 0; i < nbiv; ++i) {
            IntVarEvent evt = (IntVarEvent)this.solver.getIntVar(i).getEvent();
            if (evt.getReleased()) continue;
            LOGGER.log(Level.SEVERE, "var event non released {0}", evt);
            ok = false;
        }
        int nbsv = this.solver.getNbSetVars();
        for (int i = 0; i < nbsv; ++i) {
            SetVarEvent evt = (SetVarEvent)this.solver.getSetVar(i).getEvent();
            if (evt.getReleased()) continue;
            LOGGER.log(Level.SEVERE, "var event non released {0}", evt);
            ok = false;
        }
        return ok;
    }

    @Override
    public void freeze() {
        int idx;
        if (this.freeze == null) {
            this.freeze = new ArrayList();
        }
        while (this.v_active > 0) {
            idx = indice[this.v_active];
            while (!this.varEventQueue[idx].isEmpty()) {
                this.freeze.add(this.varEventQueue[idx].popEvent());
            }
            this.varEventQueue[idx].clear();
            this.v_active -= 1 << idx;
        }
        this.nbFrozenVE = this.freeze.size();
        while (this.c_active > 0) {
            idx = indice[this.c_active];
            while (!this.constEventQueues[idx].isEmpty()) {
                this.freeze.add(this.constEventQueues[idx].popEvent());
            }
            this.c_active -= 1 << idx;
        }
    }

    @Override
    public void unfreeze() {
        int p;
        PropagationEvent event;
        int i;
        for (i = this.freeze.size() - 1; i >= this.nbFrozenVE; --i) {
            event = this.freeze.remove(i);
            p = this.c_order[event.getPriority()];
            this.constEventQueues[p].pushEvent(event);
            this.c_active |= 1 << p;
        }
        for (i = this.nbFrozenVE - 1; i >= 0; --i) {
            event = this.freeze.remove(i);
            p = this.v_order[event.getPriority()];
            this.varEventQueue[p].pushEvent(event);
            this.v_active |= 1 << p;
        }
        this.nbFrozenVE = 0;
    }

    static {
        ChocoEngine.indice[0] = -1;
        for (int i = 0; i < ConstraintEvent.NB_PRIORITY; ++i) {
            for (int j = 1 << i; j < 1 << i + 1; ++j) {
                ChocoEngine.indice[j] = i;
            }
        }
        CHAR_NB_P = Character.forDigit(ConstraintEvent.NB_PRIORITY, 10);
    }
}

