/*
 * Decompiled with CFR 0.152.
 */
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.trailing.StoredInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class SRN
extends AbstractLargeIntSConstraint {
    private int n;
    private int[][] rank;
    private int[][] pref;
    private int[] length;
    private IStateInt[] upb;
    private IStateInt[] lwb;
    private IntDomainVar[] agent;
    private boolean trace;

    public SRN(Solver s, IntDomainVar[] agent, int[][] pref, int[][] rank, int[] length) {
        super(agent);
        this.n = agent.length;
        this.agent = agent;
        this.pref = pref;
        this.rank = rank;
        this.length = length;
        this.upb = new StoredInt[this.n];
        this.lwb = new StoredInt[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.upb[i] = s.getEnvironment().makeInt(length[i]);
            this.lwb[i] = s.getEnvironment().makeInt(0);
        }
        this.trace = false;
    }

    void display(int i) {
        System.out.print(i + ": ");
        for (int j = 0; j < this.n; ++j) {
            if (!this.agent[i].getDomain().contains(j)) continue;
            System.out.print(this.pref[i][j] + " ");
        }
        System.out.println();
    }

    void display() {
        for (int i = 0; i < this.n; ++i) {
            this.display(i);
        }
        System.out.println();
    }

    @Override
    public boolean isSatisfied() {
        if (this.trace) {
            System.out.println("isSatisfied()");
            this.display();
        }
        return true;
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.trace) {
            System.out.println("awake()");
            this.display();
        }
        for (int i = 0; i < this.n; ++i) {
            this.awakeOnInf(i);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.trace) {
            System.out.println("propagate()");
            this.display();
        }
    }

    @Override
    public void awakeOnInf(int i) throws ContradictionException {
        if (this.trace) {
            System.out.println("awakeOnInf(" + i + ")");
            this.display();
        }
        int x = this.agent[i].getInf();
        int j = this.pref[i][x];
        this.agent[j].setSup(this.rank[j][i]);
        for (int w = this.lwb[i].get(); w < x; ++w) {
            int h = this.pref[i][w];
            this.agent[h].setSup(this.rank[h][i] - 1);
        }
        this.lwb[i].set(x);
    }

    @Override
    public void awakeOnSup(int i) throws ContradictionException {
        if (this.trace) {
            System.out.println("awakeOnSup(" + i + ")");
            this.display();
        }
        int x = this.agent[i].getSup();
        for (int y = x + 1; y <= this.upb[i].get(); ++y) {
            int j = this.pref[i][y];
            this.agent[j].remVal(this.rank[j][i]);
        }
        this.upb[i].set(x);
    }

    @Override
    public void awakeOnRem(int i, int x) throws ContradictionException {
        if (this.trace) {
            System.out.println("awakeOnRem(" + i + "," + x + ")");
            this.display();
        }
        int j = this.pref[i][x];
        this.agent[j].remVal(this.rank[j][i]);
    }

    @Override
    public void awakeOnInst(int i) throws ContradictionException {
        int j;
        if (this.trace) {
            System.out.println("awakeOnInst(" + i + "," + ((IntDomainVar[])this.vars)[i].getVal() + ")");
            this.display();
        }
        int y = this.agent[i].getVal();
        for (int x = this.lwb[i].get(); x < y; ++x) {
            j = this.pref[i][x];
            this.agent[j].setSup(this.rank[j][i] - 1);
        }
        for (int z = y + 1; z <= this.upb[i].get(); ++z) {
            j = this.pref[i][z];
            this.agent[j].remVal(this.rank[j][i]);
        }
        this.lwb[i].set(y);
        this.upb[i].set(y);
    }
}

