% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR.R
\name{QR}
\alias{QR}
\title{QR Decomposition by Graham-Schmidt Orthonormalization}
\usage{
QR(X, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{X}{a numeric matrix}

\item{tol}{tolerance for detecting linear dependencies in the columns of \code{X}}
}
\value{
a list of three elements, consisting of an orthonormal matrix \code{Q}, an upper triangular matrix \code{R}, and the \code{rank}
    of the matrix \code{X}
}
\description{
\code{QR} computes the QR decomposition of a matrix, \eqn{X}, that is an orthonormal matrix, eqn{Q} and an upper triangular
matrix, \eqn{R}, such that \eqn{X = Q R}.
}
\details{
The QR decomposition plays an important role in many statistical techniques.
In particular it can be used to solve the equation \eqn{Ax = b} for given matrix \eqn{A} and vector \eqn{b}.
The function is included here simply to show the algorithm of Gram-Schmidt orthogonalization.  The standard
\code{link[base]{qr}} function is faster and more accurate.
}
\examples{
A <- matrix(c(1,2,3,4,5,6,7,8,10), 3, 3) # a nonsingular matrix
res <- QR(A)
res
q <- res$Q
zapsmall( t(q) \%*\% q)   # check that q' q = I
r <- res$R
q \%*\% r                 # check that q r = A

B <- matrix(1:9, 3, 3) # a singular matrix
QR(B)
}
\author{
John Fox and Georges Monette
}
\seealso{
\code{link[base]{qr}}
}

