% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eig.R
\name{SVD}
\alias{SVD}
\title{Singular Value Decomposition of a Matrix}
\usage{
SVD(X, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{X}{a square symmetrix matrix}

\item{tol}{tolerance passed to \code{\link{QR}}}
}
\value{
a list of three elements: \code{d}-- singular values, \code{U}-- left singular vectors, \code{V}-- right singular vectors
}
\description{
Compute the singular-value decomposition of a matrix \eqn{X} from the eigenstructure of \eqn{X'X}.
The result consists of two orthonormal matrices, \eqn{U}, and \eqn{V} and the vector \eqn{d}
of singular values, such that \eqn{X = U diag(d) V'}.
Singular values of zero are not retained in the solution.
}
\examples{
C <- matrix(c(1,2,3,2,5,6,3,6,10), 3, 3) # nonsingular, symmetric
C
SVD(C)
}
\author{
John Fox and Georges Monette
}
\seealso{
\code{\link[base]{svd}}

\code{\link{eig}}
}

