% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCXYZanalysis.R
\docType{class}
\name{ABCXYZData-class}
\alias{ABCXYZData-class}
\title{Class \code{ABCXYZData}}
\description{
This S4 class represents the result of an ABC/XYZ analysis.
}
\section{Slots}{

\describe{
\item{\code{data}}{(data.frame) The result table of an ABC/XYZ analysis.}

\item{\code{type}}{(character) The type of the analysis that has been performed. This is either 'abc' or 'abcxyz'.}

\item{\code{value}}{(character) The name of the value column in the result table.}

\item{\code{item}}{(character) Vector of the names of the item columns in the result table.}
}}

\section{Objects from the Class}{
 Objects can be created by calling the function
\code{computeABCXYZ}. This S4 class represents the result of an ABC/XYZ analysis.
}

\examples{
data("Amount")
abcResult = computeABCXYZAnalysis(data = Amount,
    value = "value",
    item = "item",
    timestamp = "date")
abcResult
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{classes}
