% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPreparation.R
\name{expandData}
\alias{expandData}
\title{Expands a temporal data frame}
\usage{
expandData(
  data,
  expand,
  expandTo = c("all", "included"),
  valueColumns,
  latest_values = F,
  valueLevels = NA,
  timestamp,
  timestampFormat = c("day", "week", "month", "quarter", "year"),
  keepData = T
)
}
\arguments{
\item{data}{Data frame that will be expanded.}

\item{expand}{Name of the variables that will be expanded.}

\item{expandTo}{Defines whether values for the variables to be expanded will be filled for all dates or only those dates included in the data.}

\item{valueColumns}{Name of the columns that are filled with specific values.}

\item{latest_values}{If True missing values are filled with the latest known value until the next known value comes in.}

\item{valueLevels}{Specific values that are used to fill the value columns. If latest_values = TRUE only values with no known values in the past of
this values are specified with this specific values.}

\item{timestamp}{Name of the column including the timestamp. This column should be in Date , YY-mm, YYYY-'W'ww, YYYY-mm, YYYY-'Q'q or YYYY format.}

\item{timestampFormat}{Declares in which format the timestamp comes in (i.e., "day", "week", "month", "quarter", "year").}

\item{keepData}{Defines whether variables that will not be expanded should be kept.}
}
\value{
Returns the expanded data frame.
}
\description{
Expands a temporal data frame and fills values for missing dates.
}
\examples{
data("Amount")
expandedItems = expandData(Amount,
    expand = c("item", "itemgroup"),
    expandTo = "all",
    valueColumns = c("amount", "value"),
    latest_values = TRUE,
    valueLevels = c(0, 0),
    timestamp = "date",
    timestampFormat = "day")
}
\seealso{
\code{\link{aggregateData}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
