% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.R
\name{sparse_similarity}
\alias{sparse_similarity}
\alias{cosine_sparse}
\alias{pearson_sparse}
\title{Compute similarity between pairs of rows of a matrix}
\usage{
cosine_sparse(X, id1, id2, ...)

pearson_sparse(X, id1, id2, ...)
}
\arguments{
\item{X}{matrix}

\item{id1}{vector of integers specifying the list of rows of \code{X}
(first set)}

\item{id2}{vector of integers specifying the list of rows of \code{X},
(second set), same length as \code{id1}.}

\item{...}{arguments passed downstream for parallel processing.}
}
\value{
data.frame with the same number of rows as the length of \code{id1}
(and \code{id2}) containing the similarity between the pairs of rows
of \code{X}. \code{sim[i] == similarity(X[id1[i], ], X[id2[i], ])}.
}
\description{
\code{cosine_sparse} computes cosine similarity between pairs of rows of a
matrix.
\code{pearson_sparse} computes pearson similarity between pairs of rows of a
matrix.
}
\examples{

set.seed(42)
X <- matrix(rnorm(5 * 3), 5, 3)

id1 <- c(1, 3)
id2 <- c(5, 4)

s1 <- matric::cosine_sparse(X, id1, id2) \%>\% dplyr::arrange(id1, id2)

Xn <- X / sqrt(rowSums(X * X))

n_rows <- nrow(Xn)

s2 <-
  expand.grid(
    id1 = seq(n_rows),
    id2 = seq(n_rows),
    KEEP.OUT.ATTRS = FALSE
  ) \%>\%
  dplyr::mutate(sim = as.vector(tcrossprod(Xn))) \%>\%
  dplyr::inner_join(s1 \%>\% dplyr::select(id1, id2)) \%>\%
  dplyr::arrange(id1, id2)

s1

all.equal(s1, s2)

Xm <- X - rowMeans(X)
s3 <- matric::cosine_sparse(Xm, id1, id2) \%>\% dplyr::arrange(id1, id2)
s4 <- matric::pearson_sparse(X, id1, id2) \%>\% dplyr::arrange(id1, id2)

all.equal(s3, s4)
}
