% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.crossvalidate.R
\name{q2}
\alias{q2}
\title{Q2	predictive relevance statistics}
\usage{
q2(originalData, predictedData, model = NULL)
}
\arguments{
\item{originalData}{A matrix or a data.frame containing the original data.}

\item{predictedData}{A matrix or a data.frame containing the predicted data that are compared
against the original data to calculate the predictive relevance statistic.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}
}
\value{
A list with \code{total}, \code{block}, and \code{indicator} elements containing
the Q2 predictive relevance statistics for the full dataset, for each indicator block, and
for each indicator
}
\description{
Calculates Q2 predictive relevance statistics based on comparing predictions
and real data.
}
\details{
The Q2 statistic is calculated as \code{1-sse/sso} where \code{sse} is the sum of 
squared prediction errors based on comparison of the \code{originalData} and 
\code{predictedData} and \code{sso} is based on prediction with mean. If the predicted
data contain the \code{groups} attribute, which indicates the groups used in blindfolding
or cross-validation, the means are calculated separately for each group excluding the 
predicted group from the calculation.
}
