% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{getcolnames_byname}
\alias{getcolnames_byname}
\title{Gets column names}
\usage{
getcolnames_byname(a)
}
\arguments{
\item{a}{The matrix or data frame from which column names are to be retrieved}
}
\value{
column names of \code{m}
}
\description{
Gets column names in a way that is amenable to use in chaining operations in a functional programming way
}
\examples{
m <- matrix(c(1:6), nrow = 2, dimnames = list(paste0("i", 1:2), paste0("c", 1:3))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
getcolnames_byname(m)
# This also works for lists
getcolnames_byname(list(m,m))
DF <- data.frame(m = I(list()))
DF[[1,"m"]] <- m
DF[[2,"m"]] <- m
getcolnames_byname(DF$m)
}
