% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{rename_to_pref_suff_byname}
\alias{rename_to_pref_suff_byname}
\title{Rename matrix rows and columns by prefix and suffix}
\usage{
rename_to_pref_suff_byname(
  a,
  sep = NULL,
  keep,
  margin = c(1, 2),
  prefix_open = "",
  prefix_close = sep,
  suffix_open = sep,
  suffix_close = ""
)
}
\arguments{
\item{a}{a matrix or list of matrices whose rows or columns will be renamed}

\item{sep}{a string that identifies the separator between prefix and suffix}

\item{keep}{one of "prefix" or "suffix" indicating which part of the row or column name to retain}

\item{margin}{one of \code{1}, \code{2}, or \code{c(1, 2)} where \code{1} indicates rows and \code{2} indicates columns}

\item{prefix_open}{a string that identifies the beginning of a prefix. Default is \code{sep}.}

\item{prefix_close}{a string that identifies the ending of a prefix. Default is "".}

\item{suffix_open}{a string that identifies the beginning of a suffix. Default is "".}

\item{suffix_close}{a string that identifies the beginning of a suffix. Default is \code{sep}.}
}
\value{
\code{a} with potentially different row or column names
}
\description{
It can be convenient to rename rows or columns of matrices
based on retaining prefixes or suffixes.
This function provides that capability.
}
\details{
A prefix is defined by an opening string (\code{prefix_open}) and a closing string (\code{prefix_close}).
A suffix is defined by an opening string (\code{suffix_open}) and a closing string (\code{suffix_close}).
If \code{sep} is provided and none of \code{prefix_open}, \code{prefix_close}, \code{suffix_open}, and \code{suffix_close} are provided,
default arguments become:
* \code{prefix_open}: "",
* \code{prefix_close}: \code{sep},
* \code{suffix_open}: \code{sep}, and
* \code{suffix_close}: "".

The \code{keep} parameter tells which portion to retain (prefixes or suffixes),

If prefixes or suffixes are not found in a row and/or column name, that name is unchanged.
}
\examples{
m <- matrix(c(1, 2, 
              3, 4, 
              5, 6), nrow = 3, byrow = TRUE, 
            dimnames = list(c("a -> b", "r2", "r3"), c("a -> b", "c -> d")))
rename_to_pref_suff_byname(m, sep = " -> ", keep = "prefix")
rename_to_pref_suff_byname(m, sep = " -> ", keep = "suffix")
}
