% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{index_column}
\alias{index_column}
\title{Index a column in a data frame by groups relative to an initial year}
\usage{
index_column(
  .DF,
  var_to_index,
  time_var = "Year",
  index_time = NULL,
  indexed_var = paste0(var_to_index, suffix),
  suffix = "_indexed"
)
}
\arguments{
\item{.DF}{the data frame in which the variables are contained}

\item{var_to_index}{the column name representing the variable to be indexed (a string)}

\item{time_var}{the name of the column containing time information.
Default is "\code{Year}".}

\item{index_time}{the time to which data in \code{var_to_index} are indexed.
If \code{NULL} (the default), \code{index_time} is set to the first time of each group.}

\item{indexed_var}{the name of the indexed variable. Default is "\code{<<var_to_index>>_<<suffix>>}".}

\item{suffix}{the suffix to be appended to the indexed variable. Default is "\code{_indexed}".}
}
\value{
a data frame with same number of rows as \code{.DF} and the following columns:
grouping variables of \code{.DF}, \code{var_to_index}, \code{time_var},
and one additional column containing indexed \code{var_to_index}
named with the value of \code{indexed_var}.
}
\description{
This function indexes (by ratio) variables in \code{vars_to_index}
to the first time in \code{time_var}
or to \code{index_time} (if specified).
Groups in \code{.DF} are both respected and required.
Neither \code{var_to_index} nor \code{time_var} can be in the grouping variables.
}
\details{
Note that this function works when the variable to index is
a column of numbers or a column of matrices.
}
\examples{
library(dplyr)
library(tidyr)
DF <- data.frame(Year = c(2000, 2005, 2010), a = c(10, 15, 20), b = c(5, 5.5, 6)) \%>\%
  gather(key = name, value = var, a, b) \%>\%
  group_by(name)
index_column(DF, var_to_index = "var", time_var = "Year", suffix = "_ratioed")
index_column(DF, var_to_index = "var", time_var = "Year", indexed_var = "now.indexed")
index_column(DF, var_to_index = "var", time_var = "Year", index_time = 2005,
             indexed_var = "now.indexed")
\dontrun{
  DF \%>\%
    ungroup() \%>\%
    group_by(name, var) \%>\%
    index_column(var_to_index = "var", time_var = "Year") # Fails! Do not group on var_to_index.
  DF \%>\%
    ungroup() \%>\%
    group_by(name, Year) \%>\%
    index_column(var_to_index = "var", time_var = "Year") # Fails! Do not group on time_var.
}
}
