% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rowcolval_to_mat}
\alias{rowcolval_to_mat}
\title{Collapse a tidy data frame into a matrix with named rows and columns}
\usage{
rowcolval_to_mat(
  .DF,
  matvals = "matvals",
  rownames = "rownames",
  colnames = "colnames",
  rowtypes = "rowtypes",
  coltypes = "coltypes",
  fill = 0
)
}
\arguments{
\item{.DF}{a tidy data frame containing columns for row names, column names, and values}

\item{matvals}{the name of the column in \code{.DF} containing values with which to fill the matrix (a string). Default is "\code{matvals}".}

\item{rownames}{the name of the column in \code{.DF} containing row names (a string). Default is "\code{rownames}".}

\item{colnames}{the name of the column in \code{.DF} containing column names (a string). Default is "\code{colnames}".}

\item{rowtypes}{an optional string identifying the types of information found in rows of the matrix to be constructed. Default is "\code{rowtypes}".}

\item{coltypes}{an optional string identifying the types of information found in columns of the matrix to be constructed. Default is "\code{coltypes}".}

\item{fill}{the value for missing entries in the resulting matrix. default is \code{0}.}
}
\value{
a matrix with named rows and columns and, optionally, row and column types
}
\description{
Columns not specified in one of \code{rownames}, \code{colnames}, \code{rowtype}, \code{coltype}, or \code{values}
are silently dropped.
\code{rowtypes} and \code{coltypes} are added as attributes to the resulting matrix
(via \code{\link{setrowtype}} and \code{\link{setcoltype}}).
The resulting matrix is a (under the hood) a data frame.
If both \code{rownames} and \code{colnames} columns of \code{.DF} contain \code{NA},
it is assumed that this is a single value, not a matrix,
in which case the value in the \code{values} column is returned.
}
\examples{
library(matsbyname)
library(dplyr)
data <- data.frame(Country  = c("GH", "GH", "GH"),
                   rows = c( "c 1",  "c 1", "c 2"),
                   cols = c( "i 1",  "i 2", "i 2"),
                   vals = c(   11  ,   12,    22 ))
A <- rowcolval_to_mat(data, rownames = "rows", colnames = "cols", matvals = "vals")
A
rowtype(A) # NULL, because types not set
coltype(A) # NULL, because types not set
B <- rowcolval_to_mat(data, rownames = "rows", colnames = "cols", matvals = "vals",
                            rowtypes  = "Commodities", coltypes  = "Industries")
B
C <- data \%>\% bind_cols(data.frame(rt = c("Commodities", "Commodities", "Commodities"),
                                   ct = c("Industries", "Industries", "Industries"))) \%>\%
  rowcolval_to_mat(rownames = "rows", colnames = "cols", matvals = "vals",
                   rowtypes = "rt", coltypes = "ct")
C
# Also works for single values if both the rownames and colnames columns contain NA
data2 <- data.frame(Country = c("GH"), rows = c(NA), cols = c(NA),
  rowtypes = c(NA), coltypes = c(NA), vals = c(2))
data2 \%>\% rowcolval_to_mat(rownames = "rows", colnames = "cols", matvals = "vals",
  rowtypes = "rowtypes", coltypes = "coltypes")
data3 <- data.frame(Country = c("GH"), rows = c(NA), cols = c(NA), vals = c(2))
data3 \%>\% rowcolval_to_mat(rownames = "rows", colnames = "cols", matvals = "vals")
# Fails when rowtypes or coltypes not all same. In data3, column rt is not all same.
data4 <- data \%>\% bind_cols(data.frame(rt = c("Commodities", "Industries", "Commodities"),
                                       ct = c("Industries", "Industries", "Industries")))
\donttest{rowcolval_to_mat(data4, rownames = "rows", colnames = "cols",
                           matvals = "vals", rowtypes = "rt", coltypes = "ct")}
}
