\name{blackboost}
\alias{blackboost}
\alias{blackboost_fit}
\title{ Gradient Boosting with Regression Trees }
\description{
  Gradient boosting for optimizing arbitrary loss functions where regression
  trees are utilized as base learners.
}
\usage{
blackboost(formula, data = list(), weights = NULL, 
    tree_controls = ctree_control(teststat = "max",
        testtype = "Teststatistic",
        mincriterion = 0,
        maxdepth = 2), ...)
blackboost_fit(object, tree_controls, fitmem, family = GaussReg(), 
    control = boost_control(), weights = NULL)
}
\arguments{
  \item{formula}{ a symbolic description of the model to be fit. }
  \item{data}{ a data frame containing the variables in the model. }
  \item{weights}{ an optional vector of weights to be used in the fitting
                  process. }
  \item{object}{ an object of class \code{boost_data}, see \code{\link{boost_dpp}}. }
  \item{tree_controls}{ an object of class \code{\link[party]{TreeControl}}, which can be
                  obtained using \code{\link[party]{ctree_control}}. 
                  Defines hyper parameters for the trees which are used as base learners. 
                  It is wise
                  to make sure to understand the consequences of altering any of its
                  arguments.}
  \item{fitmem}{ an object of class \code{\link[party]{TreeFitMemory}}.}
  \item{family}{ an object of class \code{\link{boost_family-class}},
                implementing the negative gradient corresponding
                to the loss function to be optimized, by default, 
                squared error loss
                for continuous responses is used.}
  \item{control}{ an object of class \code{\link{boost_control}}
                  which defines the hyper parameters of the
                  boosting algorithm.}
  \item{\dots}{ additional arguments passed to callies. }
}
\details{

  This function implements the `classical' 
  gradient boosting utilizing regression trees as base learners.
  Essentially, the same algorithm is implemented in package 
  \code{\link[gbm]{gbm}}.  The
  main difference is that arbitrary loss functions to be optimized 
  can be specified via the \code{family} argument to \code{blackboost} whereas
  \code{\link[gbm]{gbm}} uses hard-coded loss functions. 
  Moreover, the base learners (conditional
  inference trees, see \code{\link[party]{ctree}}) are a little bit more flexible.

  The regression fit is a black box prediction machine and thus 
  hardly interpretable. 

  Usually, the formula based interface \code{blackboost} should be used,
  the fitting procedure without data preprocessing is assessible
  via \code{blackboost_fit}, for example for cross-validation.

}
\value{
  An object of class \code{blackboost} with \code{\link{print}} 
  and \code{\link{predict}} methods being available.
}
\references{

  Jerome H. Friedman (2001), 
  Greedy function approximation: A gradient boosting machine.
  \emph{The Annals of Statistics}, \bold{29}, 1189--1232.

  Greg Ridgeway (1999), The state of boosting.
  \emph{Computing Science and Statistics}, \bold{31}, 
  172--181.

  Peter Buhlmann and Torsten Hothorn (2006),
  Boosting: A statistical perspective. Submitted manuscript.

}
\examples{

    ### a simple two-dimensional example: cars data
    cars.gb <- blackboost(dist ~ speed, data = cars,
                          control = boost_control(mstop = 50))
    cars.gb

    ### plot fit
    plot(dist ~ speed, data = cars)
    lines(cars$speed, predict(cars.gb), col = "red")

}
\keyword{models}
\keyword{regression}
