% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pert.R
\name{pert}
\alias{pert}
\alias{dpert}
\alias{ppert}
\alias{qpert}
\alias{rpert}
\title{The (Modified) PERT Distribution}
\usage{
dpert(x, min = -1, mode = 0, max = 1, shape = 4, log = FALSE, mean = 0)

ppert(
  q,
  min = -1,
  mode = 0,
  max = 1,
  shape = 4,
  lower.tail = TRUE,
  log.p = FALSE,
  mean = 0
)

qpert(
  p,
  min = -1,
  mode = 0,
  max = 1,
  shape = 4,
  lower.tail = TRUE,
  log.p = FALSE,
  mean = 0
)

rpert(n, min = -1, mode = 0, max = 1, shape = 4, mean = 0)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{min}{Vector of minima.}

\item{mode}{Vector of modes.}

\item{max}{Vector of maxima.}

\item{shape}{Vector of scaling parameters. Default value: 4.}

\item{log, log.p}{Logical; if \samp{TRUE}, probabilities \samp{p} are given as \samp{log(p)}.}

\item{mean}{Vector of means, can be specified in place of \samp{mode} as an alternative parametrization.}

\item{lower.tail}{Logical; if \samp{TRUE} (default), probabilities are \samp{P[X <= x]}, otherwise, \samp{P[X > x]}}

\item{p}{Vector of probabilities}

\item{n}{Number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
\samp{dpert} gives the density, \samp{ppert} gives the distribution function,
\samp{qpert} gives the quantile function, and \samp{rpert} generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation
for the PERT (\emph{aka} Beta PERT) distribution with minimum equals to \samp{min}, mode equals to \samp{mode}
(or, alternatively, mean equals to \samp{mean}) and maximum equals to \samp{max}.
}
\details{
The PERT distribution is a \code{\link{Beta}} distribution extended to the domain \samp{[min, max]} with mean 
\deqn{mean=\frac{min+shape\times mode+max}{shape+2}}{mean = (min + shape * mode + max)/(shape + 2)}

The underlying beta distribution is specified by \eqn{\alpha_{1}}{shape1} and \eqn{\alpha_{2}}{shape2} defined as

\deqn{\alpha_{1}=\frac{(mean-min)(2\times mode-min-max)}{(mode-mean)(max-min)}}{shape1=(mean - min)*(2 mode-min-max)/((mode-mean)*(max - min))}

\deqn{\alpha_{2}=\frac{\alpha_{1}\times (max-mean)}{mean-min}}{shape2=shape1*(max - mean)/(mean - min)}

\samp{mode} or \samp{mean} can be specified, but not both. Note: \samp{mean} is the last parameter for back-compatibility. 
A warning will be provided if some combinations of \samp{min}, \samp{mean} and \samp{max} leads to impossible mode.

David Vose (See reference) proposed a modified PERT distribution with a shape parameter different from 4. 

The PERT distribution is frequently used (with the \link{triangular} distribution) to translate expert estimates
of the min, max and mode of a random variable in a smooth parametric distribution.
}
\examples{
curve(dpert(x,min=3,mode=5,max=10,shape=6), from = 2, to = 11, lty=3,ylab="density")
curve(dpert(x,min=3,mode=5,max=10), from = 2, to = 11, add=TRUE)
curve(dpert(x,min=3,mode=5,max=10,shape=2), from = 2, to = 11, add=TRUE,lty=2)
legend(x = 8, y = .30, c("Default: 4","shape: 2","shape: 6"), lty=1:3)
## Alternatie parametrization using mean
curve(dpert(x,min=3,mean=5,max=10), from = 2, to = 11, lty=2 ,ylab="density")
curve(dpert(x,min=3,mode=5,max=10), from = 2, to = 11, add=TRUE)
legend(x = 8, y = .30, c("mode: 5","mean: 5"), lty=1:2)
}
\references{
Vose D. Risk Analysis - A Quantitative Guide (2nd and 3rd editions, John Wiley and Sons, 2000, 2008).
}
\seealso{
\code{\link{Beta}}
}
\author{
Regis Pouillot and Matthew Wiener
}
\keyword{distribution}
