% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_marg_lik.R
\name{est_marg_lik}
\alias{est_marg_lik}
\title{Estimate the marginal likelihood for an inference model.}
\usage{
est_marg_lik(
  fasta_filename,
  inference_model = beautier::create_ns_inference_model(),
  beast2_options = beastier::create_mcbette_beast2_options(),
  os = rappdirs::app_dir()$os
)
}
\arguments{
\item{fasta_filename}{name of the FASTA file}

\item{inference_model}{an inference model,
as can be created by \link[beautier]{create_inference_model}}

\item{beast2_options}{a \code{beast2_options} structure,
as can be created by \link[beastier]{create_mcbette_beast2_options}.}

\item{os}{name of the operating system,
must be \code{unix} (Linux, Mac) or \code{win} (Windows)}
}
\value{
a \link{list} showing the estimated marginal likelihoods
(and its estimated error), its items are::
\itemize{
  \item \code{marg_log_lik}: estimated marginal (natural) log likelihood
  \item \code{marg_log_lik_sd}: estimated error of \code{marg_log_lik}
  \item \code{esses} the Effective Sample Size
}
}
\description{
Estimate the marginal likelihood for an inference model.
}
\examples{
if (can_run_mcbette()) {

  # An example FASTA file
  fasta_filename <- system.file("extdata", "simple.fas", package = "mcbette")

  # A testing inference model with inaccurate (thus fast) marginal
  # likelihood estimation
  inference_model <- beautier::create_ns_inference_model()

  # Shorten the run, by doing a short (dirty, unreliable) MCMC
  inference_model$mcmc <- beautier::create_test_ns_mcmc()

  # Setup the options for BEAST2 to be able to call BEAST2 packages
  beast2_options <- beastier::create_mcbette_beast2_options()

  # Estimate the marginal likelihood
  est_marg_lik(
    fasta_filename = fasta_filename,
    inference_model = inference_model,
    beast2_options = beast2_options
  )
}
}
\seealso{
\itemize{
  \item \link{can_run_mcbette}: see if 'mcbette' can run
  \item \link{est_marg_liks}: estimate multiple marginal likelihoods
}
}
\author{
Richèl J.C. Bilderbeek
}
