% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.onedata.func.R
\name{generate.onedata}
\alias{generate.onedata}
\title{Generate (NxJ) categorical data matrix.}
\usage{
generate.onedata(N=100,J=5,Ktrue=3,q.vec=rep(3,5),noise.prop=0.3)
}
\arguments{
\item{N}{The number of observations. Default is 100.}

\item{J}{The number of active variables. Default is 5.}

\item{Ktrue}{The number of true clusters. Default is 3.}

\item{q.vec}{A vector of length J giving the number of categories for each active variable. Default is rep(3,5).}

\item{noise.prop}{A numeric value between 0 and 1 indicating the proportion of noise variables among J variables. Default is 0.3.}
}
\value{
Returns a list with the following elements.
\item{\code{data.mat}}{A (NxJ) data frame of categorical data.}
\item{\code{clstr0.vec}}{A vector of integers (from 1:Ktrue) length N giving the cluster to which each observation is allocated.}
}
\description{
Generate (NxJ) categorical data matrix.
}
\examples{
###data setting
N <- 30 ; J <- 10 ; Ktrue <- 2 ; q.vec <- rep(5,J) ; noise.prop <- 0.3
datagene <- generate.onedata(N=N,J=J,Ktrue=Ktrue,q.vec=q.vec,noise.prop = noise.prop)
}
\seealso{
\code{\link{create.prop}}, \code{\link{generate.catecls}}
}
