% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{coef.mcen}
\alias{coef.mcen}
\title{Returns the coefficients from an mcen object.}
\usage{
\method{coef}{mcen}(object, delta = NULL, ...)
}
\arguments{
\item{object}{The mcen object.}

\item{delta}{The L1 tuning parameter}

\item{...}{Additional values to pass on.}
}
\value{
The matrix of coefficients.
}
\description{
Returns the coefficients from an mcen object.
}
\examples{
x <- matrix(rnorm(400),ncol=4)
beta <- beta <- matrix(c(1,1,0,0,0,0,-1,-1,0,0,-1,-1,1,1,0,0),ncol=4)
y <- x\%*\%beta + rnorm(400) 
mcen_fit <- mcen(x,y,ky=2,gamma_y=3,delta=c(1,2))
best_coef <- coefficients(mcen_fit,delta=1)
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
