% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_all_pathways.R
\name{process_all_pathways}
\alias{process_all_pathways}
\title{Process All Pathways Analysis}
\usage{
process_all_pathways(
  pathway_infor,
  Module_Sample,
  out_DIR_Module_Sample_by_pathway,
  compare_method = c("log", "avg", "round"),
  plus_scale_method,
  comma_scale_method
)
}
\arguments{
\item{pathway_infor}{Data frame containing pathway information, see examples.}

\item{Module_Sample}{Data frame of module sample data to process}

\item{out_DIR_Module_Sample_by_pathway}{Output directory for pathway-specific results}

\item{compare_method}{Comparison method to use: "log" (log10 transform),
"avg" (average calculation), or "round" (simple rounding)}

\item{plus_scale_method}{Scaling method for plus-separated KOs ("mean", "min", or "max")}

\item{comma_scale_method}{Scaling method for comma-separated KOs ("sum" or "max")}
}
\value{
Main outputs are written to:
- Combined module file (All_modules.*.tsv)
- Pathway-specific files (via create_sub_module_sample)
}
\description{
Processes module sample data across all pathways with specified scaling methods.
Handles different comparison methods and outputs results by pathway.
}
