\name{estep.XEV}
\alias{estep.XEV}
\title{
E-step for constant shape MVN mixture models
}
\section{DESCRIPTION}{
E-step for estimating conditional probabilities from parameter estimates in an
MVN mixture model having constant shape and possibly one Poisson noise term.
}
\usage{
estep.XEV(data, mu, sigma, prob, eps, Vinv)


}
\arguments{
\item{data}{
matrix of observations.
}
\item{mu}{
matrix whose columns are the Gaussian group means.
}
\item{sigma}{
group variance matrices.
}
\item{prob}{
mixing proportions (probabilities) for each group. If \code{prob} is missing, 
the number of groups is assumed to be the number of columns in \code{mu} (no
noise). A Poisson noise term will appear in the conditional probabilities if
\code{length(prob)} is equal to \code{ncol(mu)+1}.
}
\item{eps}{
A 2-vector specifying lower bounds on the pth root of the volume of the
ellipsoids defining the clusters, where p is the data dimension, and on the
reciprocal condition number for the estimated shape of the covariance estimate.
Default : \code{c(.Machine$double.eps, .Machine$double.eps)}
}
\item{Vinv}{
An estimate of the inverse hypervolume of the data region (needed only if
\code{prob} indicates a noise term). Default : determined by function \code{hypvol}
}}
\value{
the conditional probablilities corresponding to the parameter estimates.
The loglikelihood is returned as an attribute.
}
\references{
G. Celeux and G. Govaert, Gaussian parsimonious clustering models,
\emph{Pattern Recognition, }28:781-793 (1995).


A. P. Dempster, N. M. Laird and D. B. Rubin, Maximum Likelihood from
Incomplete Data via the EM Algorithm, \emph{Journal of the Royal Statistical
Society, Series B, }39:1-22 (1977).


G. J. MacLachlan and K. E. Basford, The EM Algorithm and Extensions, Wiley
(1997).
}
\seealso{
\code{\link{estep}}, \code{\link{me.EEV}}, \code{\link{me.VEV}}, \code{\link{mstep.EEV}}, \code{\link{mstep.VEV}}
}
\examples{
data(iris)
cl <- mhclass(mhtree(iris[,1:4], modelid = "VVV"),3)
z <- me.EEV( iris[,1:4], ctoz(cl))
Mstep <- mstep.EEV(iris[,1:4], z)
estep.XEV( iris[,1:4], Mstep$mu, Mstep$sigma, Mstep$prob)




}
\keyword{clustering}
% Converted by Sd2Rd version 0.3-2.


