% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-map.R
\name{mcmc_map}
\alias{mcmc_map}
\alias{mcmc_map.mcmcarray}
\alias{mcmc_map.mcmc}
\alias{mcmc_map.mcmc.list}
\alias{mcmc_map.mcmcr}
\alias{mcmc_map.mcmcrs}
\title{MCMC Map}
\usage{
mcmc_map(.x, .f, .by = 1:npdims(.x), ...)

\method{mcmc_map}{mcmcarray}(.x, .f, .by = 1:npdims(.x), ...)

\method{mcmc_map}{mcmc}(.x, .f, .by = TRUE, ...)

\method{mcmc_map}{mcmc.list}(.x, .f, .by = TRUE, ...)

\method{mcmc_map}{mcmcr}(.x, .f, .by = TRUE, ...)

\method{mcmc_map}{mcmcrs}(.x, .f, .by = TRUE, ...)
}
\arguments{
\item{.x}{An MCMC object}

\item{.f}{The function to use}

\item{.by}{A positive integer vector of the dimensions to apply the function over.}

\item{...}{Additional arguments passed to .f.}
}
\value{
The updated MCMC object.
}
\description{
Adjust the sample values of an MCMC object using a function.
}
\section{Methods (by class)}{
\itemize{
\item \code{mcmcarray}: Adjust the sample values of an MCMC object

\item \code{mcmc}: Adjust the sample values of an mcmc.list object

\item \code{mcmc.list}: Adjust the sample values of an mcmc.list object

\item \code{mcmcr}: Adjust the sample values of an mcmcr object

\item \code{mcmcrs}: Adjust the sample values of an mcmcrs object
}}

\examples{
mcmc_map(mcmcr_example$beta, exp)
}
