% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict.mcdraws}
\alias{predict.mcdraws}
\title{Generate draws from the predictive distribution}
\usage{
\method{predict}{mcdraws}(
  object,
  newdata = NULL,
  X. = if (is.null(newdata)) "in-sample" else NULL,
  type = c("data", "link", "response", "data_cat"),
  var = NULL,
  ny = NULL,
  ry = NULL,
  fun. = identity,
  labels = NULL,
  ppcheck = FALSE,
  iters = NULL,
  to.file = FALSE,
  filename,
  write.single.prec = FALSE,
  show.progress = TRUE,
  verbose = TRUE,
  n.cores = 1L,
  cl = NULL,
  seed = NULL,
  export = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{mcdraws}, as output by \code{\link{MCMCsim}}.}

\item{newdata}{data frame with auxiliary information to be used for prediction.}

\item{X.}{a list of design matrices; alternatively, \code{X.} equals 'in-sample' or 'linpred'.
If 'in-sample' (the default if newdata is not supplied), the design matrices for in-sample
prediction are used. If 'linpred' the 'linpred_' component of \code{object} is used.}

\item{type}{the type of predictions. The default is \code{"data"}, meaning that
new data is generated according to the predictive distribution.
If \code{type="link"} only the linear predictor for the mean is generated, and
in case \code{type="response"} the linear predictor is transformed to the response scale.
For Gaussian models \code{type="link"} and \code{type="response"} are equivalent.
For binomial and negative binomial models \code{type="response"} returns the simulations
of the latent probabilities. For multinomial models \code{type="link"} generates
the linear predictor for all categories except the last, and \code{type="response"} transforms
this vector to the probability scale, and \code{type="data"} generates the multinomial data,
all in long vector format, where the output for all categories (except the last) are stacked.
For multinomial models and single trials, a further option is \code{type="data_cat"},
which generates the data as a categorical vector, with integer coded levels.}

\item{var}{variance(s) used for out-of-sample prediction. By default 1.}

\item{ny}{number of trials for used for out-of-sample prediction in case of a binomial model. By default 1.}

\item{ry}{fixed part of the (reciprocal) dispersion parameter in case of a negative binomial model.}

\item{fun.}{function applied to the vector of posterior predictions to compute one or multiple summaries
or test statistics. The function can have one or two arguments. The first argument is always the vector
of posterior predictions. The optional second argument represents a list of model parameters, needed only
when a test statistic depends on them. The function must return an integer or numeric vector.}

\item{labels}{optional names for the output object. Must be a vector of the same length as the result of \code{fun.}.}

\item{ppcheck}{if \code{TRUE}, function \code{fun.} is also applied to the observed data and
an MCMC approximation is computed of the posterior predictive probability that the test statistic for
predicted data is greater than the test statistic for the observed data.}

\item{iters}{iterations in \code{object} to use for prediction.
Default \code{NULL} means that all draws from \code{object} are used.}

\item{to.file}{if \code{TRUE} the predictions are streamed to file.}

\item{filename}{name of the file to write predictions to in case \code{to.file=TRUE}.}

\item{write.single.prec}{Whether to write to file in single precision. Default is \code{FALSE}.}

\item{show.progress}{whether to show a progress bar.}

\item{verbose}{whether to show informative messages.}

\item{n.cores}{the number of cpu cores to use. Default is one, i.e. no parallel computation.
If an existing cluster \code{cl} is provided, \code{n.cores} will be set to the number
of workers in that cluster.}

\item{cl}{an existing cluster can be passed for parallel computation. If \code{NULL} and
\code{n.cores > 1}, a new cluster is created.}

\item{seed}{a random seed (integer). For parallel computation it is used to independently
seed RNG streams for all workers.}

\item{export}{a character vector with names of objects to export to the workers. This may
be needed for parallel execution if expressions in \code{fun.} depend on global variables.}

\item{...}{currently not used.}
}
\value{
An object of class \code{dc}, containing draws from the posterior (or prior) predictive distribution.
 If \code{ppcheck=TRUE} posterior predictive p-values are returned as an additional attribute.
 In case \code{to.file=TRUE} the file name used is returned.
}
\description{
Generate draws from the predictive distribution
}
\examples{
\donttest{
n <- 250
dat <- data.frame(x=runif(n))
dat$y <- 1 + dat$x + rnorm(n)
sampler <- create_sampler(y ~ x, data=dat)
sim <- MCMCsim(sampler)
summary(sim)
# in-sample prediction
pred <- predict(sim, ppcheck=TRUE)
hist(attr(pred, "ppp"))
# out-of-sample prediction
pred <- predict(sim, newdata=data.frame(x=seq(0, 1, by=0.1)))
summary(pred)
}

}
