#' A small sample data set of four countries for illustration purposes.
#' Countries included are Benin, Sierra Leone, Madagascar, and Zimbabwe.
#' DHS survey observations for the proportion of modern contraceptives
#' supplied by the public and private sectors at the subnational
#' administration level.
#'
#' @format ## `subnat_FPsource_data`
#' A data frame with 13504 rows and 8 columns:
#' \describe{
#'   \item{Country}{Country names}
#'   \item{Region}{Subnational region names}
#'   \item{Method}{Contraceptive method name}
#'   \item{average_year}{Average year of the survey}
#'   \item{sector_categories}{Name of sector}
#'   \item{proportion}{Proportion supplied by the sector}
#'   \item{SE.proportion}{Standard error associated with the proportion}
#'   \item{n}{Sample size associated with the observation}
#' }
#' @source On request from IPUMS - https://www.idhsdata.org/idhs/index.shtml
#' @description
#' Elizabeth Heger Boyle, Miriam King and Matthew Sobek.
#' IPUMS-Demographic and Health Surveys: Version 9 (dataset).
#' IPUMS and ICF, 2022. https://doi.org/10.18128/D080.V9
"trunc_subnat_FPsource_data"
