% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairedroc.R
\name{aucTest}
\alias{aucTest}
\title{AUC Test for Paired Two-sample Measurements}
\usage{
aucTest(
  x,
  y,
  response,
  h0 = 0,
  conf.level = 0.95,
  method = c("difference", "non-inferiority", "superiority"),
  ...
)
}
\arguments{
\item{x}{(\code{numeric})\cr reference/standard diagnostic assay.}

\item{y}{(\code{numeric})\cr test diagnostic assay.}

\item{response}{(\code{numeric} or \code{factor})\cr a vector of responses to represent
the type of classes, typically encoded with 0(controls) and 1(cases).}

\item{h0}{(\code{numeric})\cr a specified hypothesized value of the margin between
the two assays, default is 0 for difference method. If you select the
non-inferiority method, the \code{h0} should be negative value. And if select
superiority method, then it's non-negative value.}

\item{conf.level}{(\code{numeric})\cr significance level between 0 and 1 (non-inclusive)
for the returned confidence interval.}

\item{method}{(\code{string})\cr string specifying the type of hypothesis test,
must be one of "difference" (default), "non-inferiority" or "superiority".}

\item{...}{other arguments to be passed to \code{\link[pROC:roc]{pROC::roc()}}.}
}
\value{
A \code{RefInt} object contains relevant results in comparing the paired
ROC of two-sample assays.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function compares two AUC of paired two-sample diagnostic assays by
standardized difference method, which has a little difference in SE calculation
with unpaired design. In order to compare the two assays, this function provides
three assessments including 'difference', 'non-inferiority' and 'superiority'.
This method of comparing is referred from Liu(2006)'s article that can be
found in reference section below.
}
\details{
If the samples are not considered independent, such as in a paired design,
the SE can not be computed by the method of Delong provided in \code{pROC} package.
Here the \code{aucTest} function use the standardized difference approach from
Liu(2006) publication to compute the SE and corresponding hypothesis test
statistic for a paired design study.
\itemize{
\item \code{difference} is to test the difference between two diagnostic tests, the
default h0 is zero.
\item \code{non-inferiority} is to test the new diagnostic tests is no worse than the
standard diagnostic test in a specific margin, but the same time maybe it's
safer, easier to administer or cost less.
\item \code{superiority} is to test the test the new diagnostic tests is better than the
standard diagnostic test in a specific margin(default is zero), having better efficacy.
}
}
\note{
The test of significance for the difference is not equal to the result of EP24A2
Appendix D. Table D2. Because the Table D2 uses the method of Hanley & McNeil
(1982), whereas this function here uses the method of DeLong et al. (1988), which
results in the difference of SE. Thus the corresponding Z statistic and P value
will be not equal as well.
}
\examples{
data("ldlroc")
# H0 : Difference between areas = 0:
aucTest(x = ldlroc$LDL, y = ldlroc$OxLDL, response = ldlroc$Diagnosis)

# H0 : Superiority margin <= 0.1:
aucTest(
  x = ldlroc$LDL, y = ldlroc$OxLDL, response = ldlroc$Diagnosis,
  method = "superiority", h0 = 0.1
)

# H0 : Non-inferiority margin <= -0.1:
aucTest(
  x = ldlroc$LDL, y = ldlroc$OxLDL, response = ldlroc$Diagnosis,
  method = "non-inferiority", h0 = -0.1
)
}
\references{
Jen-Pei Liu (2006) "Tests of equivalence and non-inferiority for
diagnostic accuracy based on the paired areas under ROC curves". \emph{Statist. Med.}
, 25:1219–1238. DOI: 10.1002/sim.2358.
}
