% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca.nipals}
\alias{pca.nipals}
\title{NIPALS based PCA algorithm}
\usage{
pca.nipals(x, ncomp = min(ncol(x), nrow(x) - 1), tol = 10^-10)
}
\arguments{
\item{x}{a matrix with data values (preprocessed)}

\item{ncomp}{number of components to calculate}

\item{tol}{tolerance (if difference in eigenvalues is smaller - convergence achieved)}
}
\value{
a list with scores, loadings and eigenvalues for the components
}
\description{
Calculates principal component space using non-linear iterative partial least squares algorithm
(NIPALS)
}
\references{
Geladi, Paul; Kowalski, Bruce (1986), "Partial Least Squares
Regression:A Tutorial", Analytica Chimica Acta 185: 1-17
}
