% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipls.R
\name{plotSelection.ipls}
\alias{plotSelection.ipls}
\title{iPLS performance plot}
\usage{
\method{plotSelection}{ipls}(
  obj,
  glob.ncomp = obj$gm$ncomp.selected,
  main = "iPLS results",
  xlab = obj$xaxis.name,
  ylab = if (is.null(obj$cv)) "RMSEP" else "RMSECV",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{obj}{iPLS results (object of class ipls).}

\item{glob.ncomp}{number of components for global PLS model with all intervals.}

\item{main}{main title for the plot.}

\item{xlab}{label for x-axis.}

\item{ylab}{label for y-axis.}

\item{xlim}{limits for x-axis.}

\item{ylim}{limits for y-axis.}

\item{...}{other arguments.}
}
\description{
Shows PLS performance for each selected or excluded intervals at the
first iteration.
}
\details{
The plot shows intervals as bars, which height corresponds to RMSECV obtained when particular
interval was selected (forward) or excluded (backward) from a model at the first iteration.
The intervals found optimal after backward/forward iPLS selection are shown with green color
while the other intervals are gray.

See examples in help for \code{\link{ipls}} function.

 @seealso
 \code{\link{summary.ipls}}, \code{\link{plotRMSE.ipls}}
}
