% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep}
\alias{prep}
\title{Class for preprocessing object}
\usage{
prep(name, params = NULL, method = NULL)
}
\arguments{
\item{name}{short text with name for the preprocessing method.}

\item{params}{a list with parameters for the method (if NULL - default parameters will be used).}

\item{method}{method to call when applying the preprocessing, provide it only for user defined methods.}
}
\description{
Class for preprocessing object
}
\details{
Use this class to create a list with a sequence of preprocessing methods to keep them together
in right order and with defined parameters. The list/object can be provided as an extra argument
to any modelling function (e.g. \code{pca}, \code{pls}, etc), so the optimal model parameters and
the optimal preprocessing will be stored together and can be applied to a raw data by using
method \code{predict}.

For your own preprocessing method you need to create a function, which takes matrix with values
(dataset) as the first argument, does something and then return a matrix with the same dimension
and same attributes as the result. The method can have any number of optional  parameters.

See Bookdown tutorial for details.
}
