% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_summary.R
\name{na_summary}
\alias{na_summary}
\title{An all-in-one missingness report}
\usage{
na_summary(
  df,
  grouping_cols = NULL,
  sort_by = NULL,
  descending = FALSE,
  exclude_cols = NULL,
  round_to = NULL
)
}
\arguments{
\item{df}{A valid R `object` for which the percentage of missing values is 
required.}

\item{grouping_cols}{A character vector. If supplied, one can provide the columns by which to group the
data.}

\item{sort_by}{One of counts or percents. This determines whether the results are sorted by counts or percentages.}

\item{descending}{Logical. Should missing values be sorted in decreasing order ie largest to smallest? Defaults to FALSE.}

\item{exclude_cols}{A character vector indicating columns to exclude when 
returning results.}

\item{round_to}{Number of places to round 2. Defaults to user digits option.}
}
\description{
An all-in-one missingness report
}
\examples{
na_summary(airquality)
# grouping
test2 <- data.frame(ID= c("A","A","B","A","B"),Vals = c(rep(NA,4),"No"),
ID2 = c("E","E","D","E","D"))
na_summary(test2,grouping_cols = c("ID","ID2"))
# sort summary
na_summary(airquality,sort_by = "percent_missing",descending = TRUE)
na_summary(airquality,sort_by = "percent_complete")

}
