% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{runMDI}
\alias{runMDI}
\title{Call Multiple Dataset Integration}
\usage{
runMDI(
  R,
  thin,
  Y,
  K,
  mixture_types,
  outlier_types,
  labels,
  fixed,
  proposal_windows
)
}
\arguments{
\item{R}{The number of iterations to run for.}

\item{thin}{thinning factor for samples recorded.}

\item{Y}{The list of data matrices to perform integrative clustering upon 
with items to cluster in rows.}

\item{K}{Vector of the number of components to model in each view. This is the upper 
limit on the number of clusters that can be found.}

\item{mixture_types}{Character vector of densities used in each view}

\item{outlier_types}{Character vector of outlier components used in each 
view ('MVT' or 'None').}

\item{labels}{Matrix item labels to initialise from. Rows correspond to the
items being clustered, columns to views.}

\item{fixed}{Binary matrix of the items that are fixed in their initial
label.}

\item{proposal_windows}{List/field of vectors}
}
\value{
Named list of the different quantities drawn by the sampler.
}
\description{
C++ function to perform MCMC sampling for MDI.
}
