% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VerticalProfiles.R
\name{vprofile_leafAreaDensity}
\alias{vprofile_leafAreaDensity}
\alias{vprofile_rootDistribution}
\alias{vprofile_fuelBulkDensity}
\alias{vprofile_PARExtinction}
\alias{vprofile_SWRExtinction}
\alias{vprofile_windExtinction}
\title{Vertical profiles}
\usage{
vprofile_leafAreaDensity(
  x,
  SpParams = NULL,
  z = NULL,
  gdd = NA,
  byCohorts = FALSE,
  bySpecies = FALSE,
  includeHerbs = FALSE,
  draw = TRUE,
  xlim = NULL
)

vprofile_rootDistribution(
  x,
  SpParams,
  d = NULL,
  bySpecies = FALSE,
  draw = TRUE,
  xlim = NULL
)

vprofile_fuelBulkDensity(
  x,
  SpParams,
  z = NULL,
  gdd = NA,
  draw = TRUE,
  xlim = NULL
)

vprofile_PARExtinction(
  x,
  SpParams,
  z = NULL,
  gdd = NA,
  includeHerbs = FALSE,
  draw = TRUE,
  xlim = c(0, 100)
)

vprofile_SWRExtinction(
  x,
  SpParams,
  z = NULL,
  gdd = NA,
  includeHerbs = FALSE,
  draw = TRUE,
  xlim = c(0, 100)
)

vprofile_windExtinction(
  x,
  SpParams,
  u = 1,
  windMeasurementHeight = 200,
  boundaryLayerSize = 2000,
  target = "windspeed",
  z = NULL,
  gdd = NA,
  includeHerbs = FALSE,
  draw = TRUE,
  xlim = NULL
)
}
\arguments{
\item{x}{An object of class \code{\link{forest}}}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}

\item{z}{A numeric vector with height values.}

\item{gdd}{Growth degree days.}

\item{byCohorts}{Separate profiles for each cohort.}

\item{bySpecies}{Aggregate cohort profiles by species.}

\item{includeHerbs}{Include herbaceous layer in the profile.}

\item{draw}{Logical flag to indicate that a plot is desired.}

\item{xlim}{Limits of the x-axis.}

\item{d}{A numeric vector with soil layer widths.}

\item{u}{The value of measured wind speed (in m/s).}

\item{windMeasurementHeight}{Height corresponding to wind measurement (in cm over the canopy).}

\item{boundaryLayerSize}{Size of the boundary layer (in cm) over the canopy.}

\item{target}{Wind property to draw, either "windspeed", "kineticenergy" (turbulent kinetic energy) or "stress" (Reynold's stress).}
}
\value{
If \code{draw = FALSE}, the functions return a numeric vector with values measured at each height. Units depend on the profile function:
\itemize{
  \item{\code{vprofile_leafAreaDensity}: Cumulative LAI (m2/m2) per height bin.}
  \item{\code{vprofile_fuelBulkDensity}: Fuel bulk density (kg/m3) per height bin.}
  \item{\code{vprofile_PARExtinction}: Percent of photosynthetically active radiation (\%) corresponding to each height.}
  \item{\code{vprofile_SWRExtinction}: Percent of shortwave radiation (\%) corresponding to each height.}
  \item{\code{vprofile_windExtinction}: Wind speed (m/s) corresponding to each height.}
}

If \code{draw = TRUE} the functions return a ggplot object, instead.
}
\description{
Functions to generate vertical profiles generated by an input \code{\link{forest}} object.
}
\examples{
#Default species parameterization
data(SpParamsMED)

#Load example plot plant data
data(exampleforestMED)

vprofile_leafAreaDensity(exampleforestMED, SpParamsMED)
vprofile_fuelBulkDensity(exampleforestMED, SpParamsMED)

vprofile_PARExtinction(exampleforestMED, SpParamsMED)
vprofile_SWRExtinction(exampleforestMED, SpParamsMED)

vprofile_windExtinction(exampleforestMED, SpParamsMED)

}
\seealso{
\code{\link{forest}}, \code{\link{plot.forest}}, \code{\link{wind_canopyTurbulence}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
