% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_spatial.R
\name{spwb_spatial}
\alias{spwb_spatial}
\alias{growth_spatial}
\alias{fordyn_spatial}
\title{Simulations for spatially-distributed forest stands}
\usage{
spwb_spatial(
  sf,
  SpParams,
  meteo = NULL,
  local_control = defaultControl(),
  dates = NULL,
  CO2ByYear = numeric(0),
  keep_results = TRUE,
  summary_function = NULL,
  summary_arguments = NULL,
  parallelize = FALSE,
  num_cores = detectCores() - 1,
  chunk_size = NULL,
  progress = TRUE,
  local_verbose = FALSE
)

growth_spatial(
  sf,
  SpParams,
  meteo = NULL,
  local_control = defaultControl(),
  dates = NULL,
  CO2ByYear = numeric(0),
  fire_regime = NULL,
  keep_results = TRUE,
  summary_function = NULL,
  summary_arguments = NULL,
  parallelize = FALSE,
  num_cores = detectCores() - 1,
  chunk_size = NULL,
  progress = TRUE,
  local_verbose = FALSE
)

fordyn_spatial(
  sf,
  SpParams,
  meteo = NULL,
  local_control = defaultControl(),
  dates = NULL,
  CO2ByYear = numeric(0),
  fire_regime = NULL,
  keep_results = TRUE,
  management_function = NULL,
  summary_function = NULL,
  summary_arguments = NULL,
  parallelize = FALSE,
  num_cores = detectCores() - 1,
  chunk_size = NULL,
  progress = TRUE,
  local_verbose = FALSE
)
}
\arguments{
\item{sf}{An object of class \code{\link{sf}} with the following columns:
\itemize{
\item{\code{geometry}: Spatial geometry.}
\item{\code{id}: Stand identifiers.}
\item{\code{elevation}: Elevation above sea level (in m).}
\item{\code{slope}: Slope (in degrees).}
\item{\code{aspect}: Aspect (in degrees).}
\item{\code{land_cover_type}: Land cover type of each grid cell (values should be 'wildland' or 'agriculture').}
\item{\code{forest}: Objects of class \code{\link{forest}}.}
\item{\code{soil}: Objects of class \code{\link{soil}} or data frames of physical properties.}
\item{\code{state}: Objects of class \code{\link{spwbInput}} or \code{\link{growthInput}} (optional).}
\item{\code{meteo}: Data frames with weather data (required if parameter \code{meteo = NULL}).}
\item{\code{crop_factor}: Crop evapo-transpiration factor. Only required for 'agriculture' land cover type.}
\item{\code{local_control}: A list of control parameters (optional). Used to override function parameter \code{local_control} for specific locations (values can be \code{NULL} for the remaining ones).}
\item{\code{management_arguments}: Lists with management arguments. Optional, relevant for \code{fordyn_spatial} only.}
\item{\code{represented_area_ha}: Area represented by each stand in hectares. Optional, relevant for \code{fordyn_spatial} when
\code{fire_regime} is supplied only).}
\item{\code{ignition_weights}: Relative weights to determine stands to be burned. Optional, relevant for \code{fordyn_spatial} when
\code{fire_regime} is supplied only).}
}}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}

\item{meteo}{Input meteorological data (see section details). If NULL, the function will expect a column 'meteo' in parameter \code{y}.}

\item{local_control}{A list of control parameters (see \code{\link{defaultControl}}) for function \code{\link{spwb_day}} or \code{\link{growth_day}}.}

\item{dates}{A \code{\link{Date}} object describing the days of the period to be modeled.}

\item{CO2ByYear}{A named numeric vector with years as names and atmospheric CO2 concentration (in ppm) as values. Used to specify annual changes in CO2 concentration along the simulation (as an alternative to specifying daily values in \code{meteo}).}

\item{keep_results}{Boolean flag to indicate that point/cell simulation results are to be returned (set to \code{FALSE} and use summary functions for large data sets).}

\item{summary_function}{An appropriate function to calculate summaries (e.g., \code{\link{summary.spwb}}).}

\item{summary_arguments}{List with additional arguments for the summary function.}

\item{parallelize}{Boolean flag to try parallelization (will use all clusters minus one).}

\item{num_cores}{Integer with the number of cores to be used for parallel computation.}

\item{chunk_size}{Integer indicating the size of chuncks to be sent to different processes (by default, the number of spatial elements divided by the number of cores).}

\item{progress}{Boolean flag to display progress information of simulations.}

\item{local_verbose}{Boolean flag to display detailed progress information in local simulations.}

\item{fire_regime}{A list of parameters defining the fire regime (see \code{\link{create_fire_regime}}) or
a matrix representing a fire regime instance (see \code{\link{fire_regime_instance}}),
to be used in simulations with \code{\link{fordyn_spatial}}. If NULL, wildfires are not simulated.}

\item{management_function}{A function that implements forest management actions (see \code{\link{fordyn}}).
of such lists, one per spatial unit.}
}
\value{
An object of class 'sf' containing four elements:
\itemize{
\item{\code{geometry}: Spatial geometry.}
\item{\code{id}: Stand id, taken from the input.}
\item{\code{state}: A list of \code{\link{spwbInput}} or \code{\link{growthInput}} objects for each simulated stand, to be used in subsequent simulations (see \code{\link{update_landscape}}) or with NULL values whenever simulation errors occurred.}
\item{\code{forest}: A list of \code{\link{forest}} objects for each simulated stand (only in function \code{fordyn_spatial}), to be used in subsequent simulations (see \code{\link{update_landscape}}) or with NULL values whenever simulation errors occurred.}
\item{\code{management_arguments}: A list of management arguments for each simulated stand (only in function \code{fordyn_spatial} if management function was supplied), to be used in subsequent simulations (see \code{\link{update_landscape}}).}
\item{\code{result}: A list of model output for each simulated stand. Some elements can contain an error condition if the simulation resulted in an error. Values will be NULL (or errors) if \code{keep_results = FALSE}.}
\item{\code{summary}: A list of model output summaries for each simulated stand (if \code{summary_function} was not \code{NULL}), with NULL values whenever simulation errors occurred.}
}
}
\description{
Functions that allow calling local models \code{\link{spwb}}, \code{\link{growth}} or \code{\link{fordyn}}, for a set of forest stands distributed in specific locations.
No spatial processes are simulated.
}
\details{
Simulation functions  accept different formats for meteorological input (parameter \code{meteo}).
The user may supply two kinds of daily weather sources:
\enumerate{
\item{A data frame with meteorological data common for all spatial location (spatial variation of weather not considered).}
\item{An object or (a list of objects) of class \code{\link{stars}} with reference interpolation data created by package \code{\link{meteoland}}.
If a list of such \emph{interpolator} objects is supplied, the simulation functions will interpolate on the target locations for the periods covered by each interpolator,
but the user will be responsible for supplying interpolators in the correct temporal order.}
}
Alternatively, the user may leave parameter \code{meteo = NULL} and specify a weather data frame for each element of \code{y}
in a column named 'meteo'.

Fire regimes are only allowed for function \code{fordyn_spatial}. If an object of class \code{fire_regime} is supplied, the function will call
\code{\link{fire_regime_instance}} to generate a realization of the fire regime before conducting simulations. Alternatively,
users can directly supply a fire regime instance matrix, derived from another source (e.g. a fire landscape model). Note that operating
with fire regimes assumes all forest stands share the same period of simulation, but enforcing this is left to the user.
}
\examples{
\donttest{
# Load example landscape data
data("example_ifn")
  
# Load example meteo data frame from package meteoland
data("examplemeteo")
  
# Load default medfate parameters
data("SpParamsMED")
  
# Subset two plots to speed-up calculations
example_subset <- example_ifn[31:32, ]

# Perform simulation
dates <- seq(as.Date("2001-03-01"), as.Date("2001-03-15"), by="day")
res <- spwb_spatial(example_subset, SpParamsMED, examplemeteo, dates = dates)
  
# Perform fordyn simulation for one year (one stand) without management
res_noman <- fordyn_spatial(example_subset, SpParamsMED, examplemeteo)

}

}
\seealso{
\code{\link{spwb}}, \code{\link{growth}}, \code{\link{fordyn}}, \code{\link{spwb_spatial_day}},
\code{\link{simulation_summary}} , \code{\link{plot_summary}},
\code{\link{initialize_landscape}}, \code{\link{update_landscape}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
