% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/neLht.R
\name{neLht-methods}
\alias{confint.neLht}
\alias{confint.neLhtBoot}
\alias{neLht-methods}
\alias{summary.neLht}
\title{Methods for linear hypotheses in natural effect models}
\usage{
\method{confint}{neLhtBoot}(object, parm, level = 0.95, type = "norm", ...)

\method{confint}{neLht}(object, parm, level = 0.95,
  calpha = univariate_calpha(), ...)

\method{summary}{neLht}(object, test = univariate(), ...)
}
\arguments{
\item{object}{an object of class \code{neLht}.}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{type}{the type of bootstrap intervals required. The default \code{"norm"} returns normal approximation bootstrap confidence intervals. Currently, \code{"norm"}, \code{"basic"}, \code{"perc"} and \code{"bca"} are supported (see \code{\link[boot]{boot.ci}}).}

\item{...}{additional arguments.}

\item{calpha}{a function computing the critical value. The default \code{univariate_calpha()} returns unadjusted confidence intervals, whereas \code{adjusted_calpha()} returns adjusted confidence intervals.}

\item{test}{a function for computing p-values. The default \code{univariate()} does not apply a multiple testing correction. The function \code{adjusted()} allows to correct for multiple testing (see \code{\link[multcomp]{summary.glht}} and \code{\link[multcomp]{adjusted}}) and \code{Chisquare()} allows to test global linear hypotheses.}
}
\description{
Obtain confidence intervals and statistical tests for linear hypotheses in natural effect models.
}
\details{
\code{confint} yields bootstrap confidence intervals  or confidence intervals based on the sandwich estimator (depending on the type of standard errors requested when fitting the \code{\link{neModel}} object).
Bootstrap confidence intervals are internally called via the \code{\link[boot]{boot.ci}} function from the \pkg{boot} package.
Confidence intervals based on the sandwich estimator are internally called via the corresponding \code{\link[multcomp]{confint.glht}} function from the \pkg{multcomp} package.
The default confidence level specified in \code{level} (which corresponds to the \code{conf} argument in \code{\link[boot]{boot.ci}}) is 0.95
and the default type of bootstrap confidence interval, \code{"norm"}, is based on the normal approximation.
Bias-corrected and accelerated (\code{"bca"}) bootstrap confidence intervals require a sufficiently large number of bootstrap replicates (for more details see \code{\link[boot]{boot.ci}}).

A summary table with large sample tests, similar to that for \code{\link[multcomp]{glht}}, can be obtained using \code{summary}.

In contrast to \code{\link[multcomp]{summary.glht}}, which by default returns \emph{p}-values that are adjusted for multiple testing,
the summary function returns unadjusted \emph{p}-values. Adjusted \emph{p}-values can also be obtained by specifying the \code{test} argument
(see \code{\link[multcomp]{adjusted}} for more details).

Global Wald tests considering all linear hypotheses simultaneously (i.e. testing the global null hypothesis)
can be requested by specifying \code{test = Chisqtest()}.

See \code{\link[=coef.glht]{glht-methods}} for additional methods for \code{glht} objects.
}
\note{
For the bootstrap, \emph{z}-values in the summary table are simply calculated by dividing the parameter estimate by its corresponding bootstrap standard error.
Corresponding \emph{p}-values in the summary table are only indicative, since the null distribution for each statistic is assumed to be approximately standard normal.
Therefore, whenever possible, it is recommended to focus mainly on bootstrap confidence intervals for inference, rather than the provided \emph{p}-values.
}
\examples{
data(UPBdata)

impData <- neImpute(UPB ~ att * negaff + gender + educ + age,
                    family = binomial, data = UPBdata)
neMod <- neModel(UPB ~ att0 * att1 + gender + educ + age,
                 family = binomial, expData = impData, se = "robust")

lht <- neLht(neMod, linfct = c("att0 = 0", "att0 + att0:att1 = 0",
                               "att1 = 0", "att1 + att0:att1 = 0",
                               "att0 + att1 + att0:att1 = 0"))

## obtain confidence intervals
confint(lht)
confint(lht, parm = c("att0", "att0 + att0:att1"))
confint(lht, parm = 1:2, level = 0.90)

## summary table
summary(lht)

## summary table with omnibus Chisquare test
summary(lht, test = Chisqtest())
}
\seealso{
\code{\link{neLht}}, \code{\link{plot.neLht}}, \code{\link[multcomp]{glht}}, \code{\link[=coef.glht]{glht-methods}}
}

