% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_annual_top5.R
\encoding{UTF-8}
\name{get_annual_top5}
\alias{get_annual_top5}
\title{Get data on annual market expectations for the Top 5 indicators (Focus/BCB)}
\usage{
get_annual_top5(
  indicator = NULL,
  detail = NULL,
  first_date = Sys.Date() - 2 * 365,
  last_date = Sys.Date(),
  reference_date = NULL,
  calc_type = NULL,
  be_quiet = FALSE,
  use_memoise = TRUE,
  do_parallel = FALSE
)
}
\arguments{
\item{indicator}{A single string or a character vector with economic indicators names, see details for possible values. Defaults to NULL.}

\item{detail}{A single string. Defaults to NULL.}

\item{first_date}{A single string or Date in "YYYY-mm-dd" format. Default for 2 years prior to the current date.}

\item{last_date}{A single string or Date in "YYYY-mm-dd" format. Default is the current date.}

\item{reference_date}{A single string in "YYYY" format, indicating the reference year for which the statistic is expected. Defaults to NULL.}

\item{calc_type}{A single string, NULL or a character vector indicating the calculation type (term) of the statistics. See details for possible values. Defaults to NULL.}

\item{be_quiet}{Logical. Should messages or warnings not be displayed? Defaults to FALSE.}

\item{use_memoise}{Logical. Sets the use of caching system, creating a folder named "cache_bcb" by default. Default to TRUE.}

\item{do_parallel}{Logical. For using parallel data importation. Defaults to FALSE.}
}
\value{
A tibble with data from BCB-Olinda Data Services.
}
\description{
This function provides the extraction of data and statistics related to the expectations of economic indicators, specifically the annual market expectations of the indicators of the Top 5 Focus ranking, made available by the Central Bank of Brazil's Expectations System through the Olinda API. The data comes from several financial institutions: banks, funds, research houses, etc. Important: arguments are case sensitive.
}
\details{
For periods for which there are no statistics, they will be omitted from the query.

Possible values for indicator argument: "IGP-DI", "IGP-M", "IPCA", "Meta para taxa over-selic", "Taxa de câmbio".

Possible values for detail argument: if indicator "Meta para taxa over-selic" or "Taxa de câmbio" -> "Fim do ano" / "Media do ano".

Possible values for calc_type argument: "short", "medium" or "long".
}
\examples{
df <- get_annual_top5(
  indicator = "IPCA",
  first_date = Sys.Date() - 30,
  reference_date = format(Sys.Date(), "\%Y"),
  use_memoise = FALSE
)
}
\author{
Fernando da Silva <\href{mailto:fernando@fortietwo.com}{fernando@fortietwo.com}>
}
