% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/conv-methods.R
\name{conv}
\alias{conv}
\alias{conv,EL-method}
\alias{conv,CEL-method}
\alias{conv,ELT-method}
\title{Convergence check}
\usage{
\S4method{conv}{EL}(object, ...)

\S4method{conv}{CEL}(object, ...)

\S4method{conv}{ELT}(object, ...)
}
\arguments{
\item{object}{An object that inherit from \linkS4class{EL}, including
\linkS4class{CEL}, \linkS4class{LM}, and \linkS4class{GLM}.}

\item{...}{Further arguments passed to methods.}
}
\value{
A single logical.
}
\description{
Extracts convergence status from a model.
}
\section{Methods (by class)}{
\itemize{
\item \code{EL}: Extracts the convergence status of the model with respect to
the Lagrange multiplier.

\item \code{CEL}: Extracts the convergence status of the model with respect to
the parameter.

\item \code{ELT}: Extracts the convergence status of the model with respect to
the parameter (or the Lagrange multiplier if \code{lhs} is \code{NULL}).
}}

\examples{
## Convergence check for the overall model test
data("mtcars")
fit <- el_lm(mpg ~ ., data = mtcars)
conv(fit)
}
