% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car_shiny.R
\name{car_shiny}
\alias{car_shiny}
\title{The ca(R) Shiny promotional meme}
\usage{
car_shiny(file, p1 = NULL, p2 = NULL, fps = 10, test_frame = FALSE, mult = 1)
}
\arguments{
\item{file}{character, output filename.}

\item{p1}{ggplot object for top half of (ca)R Shiny meme.}

\item{p2}{ggplot object for bottom half of (ca)R Shiny meme.}

\item{fps}{integer, frames per second.}

\item{test_frame}{logical, keep only the first frame. Ideal for saving time during testing.}

\item{mult}{numeric, factor by which to multiply the output meme dimensions. Use conservatively.}
}
\value{
nothing is returned, but a file is saved to disk.
}
\description{
Recreate the ca(R) Shiny promotional meme using different plots, frame rate or output size.
}
\details{
This function offers limited control over customization; it is intended as a canned example.
For additional customization, use this function's source code in an R script where you can easily alter other values.

After writing the first layer of output to \code{file}, \code{file} is recursively read and written again
two more times in order to add all layers to the animated gif, since the underlying \code{meme} function does not accept vectorized inset plots.

The Shiny logo is by RStudio.
}
\examples{
library(ggplot2)
file <- "memery-car-shiny.gif" # outfile
set.seed(1)
p1 <- ggplot(data.frame(x = rbeta(100000, 10, 3)), aes(x)) +
  geom_histogram(colour = "white", fill = "#88888880", size = 1, bins = 30)

means <- (8:1)^3
sds <- 10*(8:1)
d <- data.frame(
  x = rep(factor(1:8), each = 100),
  y = unlist(purrr::map2(means, sds, ~rnorm(100, .x, .y) / 200))
)

p2 <- ggplot(d, aes(x, y)) +
  geom_boxplot(colour = "white", fill = "#5495CF80", outlier.colour = NA) +
  geom_point(shape = 21, colour = "white", fill = "#5495CF80", size = 1,
             position = position_jitter(0.15)) +
  scale_x_discrete(expand = c(0, 0.02)) + scale_y_continuous(expand = c(0.02, 0)) +
  theme_void() +
  theme(plot.margin = unit(rep(5, 4), "mm"),
        panel.grid.major = element_line(colour = "#FFFFFF50", linetype = 2),
        panel.grid.minor = element_line(colour = "#FFFFFF50", linetype = 2))

\dontrun{car_shiny(file, p1, p2, test_frame = TRUE)}
}
