% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{k_dist}
\alias{k_dist}
\title{Maximum difference between cumulative degree distribution}
\usage{
k_dist(adj_1, adj_2, weights_1 = NULL, weights_2 = NULL,
  mode_1 = "undirected", mode_2 = "undirected")
}
\arguments{
\item{adj_1}{numeric matrix representing the adjacency matrix of graph 1.}

\item{adj_2}{numeric matrix representing the adjacency matrix of graph 2.}

\item{weights_1, weights_2}{numeric vector of edge weights for network 1 and
2, respectively. Optional.}

\item{mode_1, mode_2}{character, either \code{"directed"} or \code{"undirected"},
specifying whether network 1 and 2 should be interepeted as directed
or undirected, respectively. Defaults to \code{"undirected"}.}
}
\value{
Distance between cumulative degree distributions.
}
\description{
Determines the maximum difference between the cumulative
degree distributions of two graphs
}
\examples{

# get fluency data
data(animal_fluency)

# edge lists of fluency graphs
edge_list_1 = threshold_graph(animal_fluency[1:100])
edge_list_2 = threshold_graph(animal_fluency[101:200])

# get adjacency matrices
adj_1 = edg_to_adj(edge_list_1)
adj_2 = edg_to_adj(edge_list_2)

# get max degree distance
k_dist(adj_1, adj_2)

}
